<head>
	<meta name="layout" content="main" />
	<title>Edit Person</title>
</head>

<body>

	<div class="nav">
		<span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
		<span class="menuButton"><g:link class="list" action="list">Person List</g:link></span>
		<span class="menuButton"><g:link class="create" action="create">New Person</g:link></span>
	</div>

	<div class="body">
		<h1>Edit Person</h1>
		<g:if test="${flash.message}">
		<div class="message">${flash.message}</div>
		</g:if>
		<g:hasErrors bean="${person}">
		<div class="errors">
			<g:renderErrors bean="${person}" as="list" />
		</div>
		</g:hasErrors>

		<div class="prop">
			<span class="name">ID:</span>
			<span class="value">${person.id}</span>
		</div>

		<g:form>
			<input type="hidden" name="id" value="${person.id}" />
			<input type="hidden" name="version" value="${person.version}" />
			<div class="dialog">
				<table>
				<tbody>

					<tr class="prop">
						<td valign="top" class="name"><label for="loginName">Login Name:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'loginName','errors')}">
							<input type="text" id="loginName" name="loginName" value="${person.loginName?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="firstName">Full Name:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'firstName','errors')}">
							<input type="text" id="firstName" name="firstName" value="${person.firstName?.encodeAsHTML()}"/>
						</td>
					</tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="lastName">Full Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'lastName','errors')}">
                            <input type="text" id="lastName" name="lastName" value="${person.lastName?.encodeAsHTML()}"/>
                        </td>
                    </tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="password">Password:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'password','errors')}">
							<input type="password" id="password" name="password" value="${person.password?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="isActive">isActive:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'isActive','errors')}">
							<g:checkBox name="isActive" value="${person.isActive}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="description">Description:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'description','errors')}">
							<input type="text" id="description" name="description" value="${person.description?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="email">Email:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'email','errors')}">
							<input type="text" id="email" name="email" value="${person?.email?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="emailShow">Show Email:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'emailShow','errors')}">
							<g:checkBox name="emailShow" value="${person.emailShow}"/>
						</td>
					</tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="employeeID">employee ID:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'employeeID','errors')}">
                            <input type="text" id="employeeID" name="employeeID" value="${person.employeeID?.encodeAsHTML()}"/>
                        </td>
                    </tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="authorities">Authorities:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'authorities','errors')}">
							<ul>
							<g:each var="entry" in="${roleMap}">
								<li>${entry.key.authority.encodeAsHTML()}
									<g:checkBox name="${entry.key.authority}" value="${entry.value}"/>
								</li>
							</g:each>
							</ul>
						</td>
					</tr>

				</tbody>
				</table>
			</div>

			<div class="buttons">
				<span class="button"><g:actionSubmit class="save" value="Update" /></span>
				<span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
			</div>

		</g:form>

	</div>
</body>
