

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit PersonGroupType</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">PersonGroupType List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New PersonGroupType</g:link></span>
        </div>
        <div class="body">
            <h1>Edit PersonGroupType</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${personGroupTypeInstance}">
            <div class="errors">
                <g:renderErrors bean="${personGroupTypeInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${personGroupTypeInstance?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personGroupTypeInstance,field:'name','errors')}">
                                    <input type="text" maxlength="50" id="name" name="name" value="${fieldValue(bean:personGroupTypeInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personGroupTypeInstance,field:'description','errors')}">
                                    <input type="text" maxlength="100" id="description" name="description" value="${fieldValue(bean:personGroupTypeInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personGroupTypeInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${personGroupTypeInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="personGroups">Person Groups:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personGroupTypeInstance,field:'personGroups','errors')}">
                                    
<ul>
<g:each var="p" in="${personGroupTypeInstance?.personGroups?}">
    <li><g:link controller="personGroup" action="show" id="${p.id}">${p?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="personGroup" params="['personGroupType.id':personGroupTypeInstance?.id]" action="create">Add PersonGroup</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
