/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.htmlparser.visitors.NodeVisitor;

public class NodeList
implements Serializable {
    private static final int INITIAL_CAPACITY = 10;
    private Node[] nodeData;
    private int size;
    private int capacity;
    private int capacityIncrement;

    public NodeList() {
        this.removeAll();
    }

    public NodeList(Node node) {
        this();
        this.add(node);
    }

    public void add(Node node) {
        if (this.size == this.capacity) {
            this.adjustVectorCapacity();
        }
        this.nodeData[this.size++] = node;
    }

    public void add(NodeList list) {
        for (int i = 0; i < list.size; ++i) {
            this.add(list.nodeData[i]);
        }
    }

    public void prepend(Node node) {
        if (this.size == this.capacity) {
            this.adjustVectorCapacity();
        }
        System.arraycopy(this.nodeData, 0, this.nodeData, 1, this.size);
        ++this.size;
        this.nodeData[0] = node;
    }

    private void adjustVectorCapacity() {
        this.capacity += this.capacityIncrement;
        this.capacityIncrement *= 2;
        Node[] oldData = this.nodeData;
        this.nodeData = this.newNodeArrayFor(this.capacity);
        System.arraycopy(oldData, 0, this.nodeData, 0, this.size);
    }

    private Node[] newNodeArrayFor(int capacity) {
        return new Node[capacity];
    }

    public int size() {
        return this.size;
    }

    public Node elementAt(int i) {
        return this.nodeData[i];
    }

    public SimpleNodeIterator elements() {
        return new SimpleNodeIterator(){
            int count = 0;

            public boolean hasMoreNodes() {
                return this.count < NodeList.this.size;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Node nextNode() {
                NodeList nodeList = NodeList.this;
                synchronized (nodeList) {
                    if (this.count < NodeList.this.size) {
                        return NodeList.this.nodeData[this.count++];
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public Node[] toNodeArray() {
        Node[] nodeArray = this.newNodeArrayFor(this.size);
        System.arraycopy(this.nodeData, 0, nodeArray, 0, this.size);
        return nodeArray;
    }

    public void copyToNodeArray(Node[] array) {
        System.arraycopy(this.nodeData, 0, array, 0, this.size);
    }

    public String asString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            buff.append(this.nodeData[i].toPlainTextString());
        }
        return buff.toString();
    }

    public String toHtml(boolean verbatim) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            ret.append(this.nodeData[i].toHtml(verbatim));
        }
        return ret.toString();
    }

    public String toHtml() {
        return this.toHtml(false);
    }

    public Node remove(int index) {
        Node ret = this.nodeData[index];
        System.arraycopy(this.nodeData, index + 1, this.nodeData, index, this.size - index - 1);
        this.nodeData[this.size - 1] = null;
        --this.size;
        return ret;
    }

    public void removeAll() {
        this.size = 0;
        this.capacity = 10;
        this.nodeData = this.newNodeArrayFor(this.capacity);
        this.capacityIncrement = this.capacity * 2;
    }

    public boolean contains(Node node) {
        return -1 != this.indexOf(node);
    }

    public int indexOf(Node node) {
        int ret = -1;
        for (int i = 0; i < this.size && -1 == ret; ++i) {
            if (!this.nodeData[i].equals(node)) continue;
            ret = i;
        }
        return ret;
    }

    public boolean remove(Node node) {
        boolean ret = false;
        int index = this.indexOf(node);
        if (-1 != index) {
            this.remove(index);
            ret = true;
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            ret.append(this.nodeData[i]);
        }
        return ret.toString();
    }

    public NodeList extractAllNodesThatMatch(NodeFilter filter) {
        return this.extractAllNodesThatMatch(filter, false);
    }

    public NodeList extractAllNodesThatMatch(NodeFilter filter, boolean recursive) {
        NodeList ret = new NodeList();
        for (int i = 0; i < this.size; ++i) {
            NodeList children;
            Node node = this.nodeData[i];
            if (filter.accept(node)) {
                ret.add(node);
            }
            if (!recursive || null == (children = node.getChildren())) continue;
            ret.add(children.extractAllNodesThatMatch(filter, recursive));
        }
        return ret;
    }

    public void keepAllNodesThatMatch(NodeFilter filter) {
        this.keepAllNodesThatMatch(filter, false);
    }

    public void keepAllNodesThatMatch(NodeFilter filter, boolean recursive) {
        int i = 0;
        while (i < this.size) {
            NodeList children;
            Node node = this.nodeData[i];
            if (!filter.accept(node)) {
                this.remove(i);
                continue;
            }
            if (recursive && null != (children = node.getChildren())) {
                children.keepAllNodesThatMatch(filter, recursive);
            }
            ++i;
        }
    }

    public void visitAllNodesWith(NodeVisitor visitor) throws ParserException {
        visitor.beginParsing();
        for (int i = 0; i < this.size; ++i) {
            this.nodeData[i].accept(visitor);
        }
        visitor.finishedParsing();
    }
}

