/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SEPUri {
    public static final String APPEND_LOCAL = "local";
    public static final String APPEND_AUTHORITY = "authority";
    public static final String APPEND_PATH = "path";
    public static final String APPEND_QUERY = "query";
    public static final String APPEND_QXRI = "qxri";
    public static final String APPEND_NONE = "none";
    protected static Log soLog = LogFactory.getLog((String)XRD.class.getName());
    public static final String DEFAULT_APPEND = "local";
    private URI uri;
    private Integer priority;
    private String append;

    public SEPUri() throws URISyntaxException {
        this(null, null, null);
    }

    public SEPUri(String uri) throws URISyntaxException {
        this(uri, null, null);
    }

    public SEPUri(String uri, int priority) throws URISyntaxException {
        this(uri, new Integer(priority), null);
    }

    public SEPUri(String uri, Integer priority, String append) throws URISyntaxException {
        this.uri = uri == null ? null : new URI(uri);
        this.priority = priority;
        this.append = append;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(String uri) throws URISyntaxException {
        URI o = new URI(uri);
        this.setURI(o);
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = new Integer(priority);
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getAppend() {
        return this.append;
    }

    public void setAppend(String append) {
        this.append = append;
    }

    public Element toXML(Document doc, String tag) {
        Element body = doc.createElement(tag);
        if (this.priority != null) {
            body.setAttribute("priority", this.priority.toString());
        }
        if (this.append != null) {
            body.setAttribute("append", this.append);
        }
        body.appendChild(doc.createTextNode(this.uri.toString()));
        return body;
    }

    public static SEPUri fromXML(Node root) throws URISyntaxException {
        Element el = (Element)root;
        SEPUri xin = new SEPUri();
        xin.setURI(DOMUtils.getText(root).trim());
        if (el.hasAttribute("priority")) {
            try {
                int priority = Integer.parseInt(el.getAttribute("priority"));
                xin.setPriority(priority);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (el.hasAttribute("append")) {
            xin.setAppend(el.getAttribute("append").trim());
        }
        return xin;
    }

    private String toString(String tag) {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toXML((Document)doc, tag);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public String toString() {
        return this.toString("URI");
    }

    public Object clone() {
        try {
            return new SEPUri(this.uri == null ? null : this.uri.toString(), this.priority == null ? null : this.priority, this.append);
        }
        catch (URISyntaxException synException) {
            soLog.error((Object)("couldn't clone the SEPUri object: " + this.uri));
            return null;
        }
    }
}

