/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.openid;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.openid.OpenIDAuthenticationToken;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.openid.OpenIDAuthenticationRequiredException;
import org.springframework.security.ui.openid.OpenIDConsumer;
import org.springframework.security.ui.openid.OpenIDConsumerException;
import org.springframework.security.ui.openid.consumers.OpenID4JavaConsumer;
import org.springframework.util.StringUtils;

public class OpenIDAuthenticationProcessingFilter
extends AbstractProcessingFilter {
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$security$ui$openid$OpenIDAuthenticationProcessingFilter == null ? (class$org$springframework$security$ui$openid$OpenIDAuthenticationProcessingFilter = OpenIDAuthenticationProcessingFilter.class$("org.springframework.security.ui.openid.OpenIDAuthenticationProcessingFilter")) : class$org$springframework$security$ui$openid$OpenIDAuthenticationProcessingFilter));
    public static final String DEFAULT_CLAIMED_IDENTITY_FIELD = "j_username";
    private OpenIDConsumer consumer;
    private String claimedIdentityFieldName = "j_username";
    private Map realmMapping = new HashMap();
    static /* synthetic */ Class class$org$springframework$security$ui$openid$OpenIDAuthenticationProcessingFilter;
    static /* synthetic */ Class class$org$springframework$security$ui$openid$OpenIDAuthenticationRequiredException;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.consumer == null) {
            this.consumer = new OpenID4JavaConsumer();
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest req) throws AuthenticationException {
        OpenIDAuthenticationToken token;
        String identity = req.getParameter("openid.identity");
        if (!StringUtils.hasText((String)identity)) {
            String username = this.obtainUsername(req);
            this.setLastUsername(username, req);
            throw new OpenIDAuthenticationRequiredException("External Authentication Required", username);
        }
        try {
            token = this.consumer.endConsumption(req);
        }
        catch (OpenIDConsumerException oice) {
            throw new AuthenticationServiceException("Consumer error", (Throwable)oice);
        }
        token.setDetails(this.authenticationDetailsSource.buildDetails((Object)req));
        Authentication authentication = this.getAuthenticationManager().authenticate((Authentication)token);
        if (authentication.isAuthenticated()) {
            this.setLastUsername(token.getIdentityUrl(), req);
        }
        return authentication;
    }

    private void setLastUsername(String username, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null || this.getAllowSessionCreation()) {
            request.getSession().setAttribute("SPRING_SECURITY_LAST_USERNAME", (Object)username);
        }
    }

    protected String determineFailureUrl(HttpServletRequest request, AuthenticationException failed) {
        OpenIDAuthenticationRequiredException openIdRequiredException;
        String claimedIdentity;
        if (failed instanceof OpenIDAuthenticationRequiredException && StringUtils.hasText((String)(claimedIdentity = (openIdRequiredException = (OpenIDAuthenticationRequiredException)failed).getClaimedIdentity()))) {
            try {
                String returnToUrl = this.buildReturnToUrl(request);
                String realm = this.lookupRealm(returnToUrl);
                return this.consumer.beginConsumption(request, claimedIdentity, returnToUrl, realm);
            }
            catch (OpenIDConsumerException e) {
                log.error((Object)("Unable to consume claimedIdentity [" + claimedIdentity + "]"), (Throwable)e);
            }
        }
        return super.determineFailureUrl(request, failed);
    }

    protected String lookupRealm(String returnToUrl) {
        String mapping = (String)this.realmMapping.get(returnToUrl);
        if (mapping == null) {
            try {
                URL url = new URL(returnToUrl);
                int port = url.getPort() == -1 ? 80 : url.getPort();
                StringBuffer realmBuffer = new StringBuffer(returnToUrl.length()).append(url.getProtocol()).append("://").append(url.getHost()).append(":").append(port).append("/");
                mapping = realmBuffer.toString();
            }
            catch (MalformedURLException e) {
                log.warn((Object)("returnToUrl was not a valid URL: [" + returnToUrl + "]"), (Throwable)e);
            }
        }
        return mapping;
    }

    protected String buildReturnToUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public String getClaimedIdentityFieldName() {
        return this.claimedIdentityFieldName;
    }

    public OpenIDConsumer getConsumer() {
        return this.consumer;
    }

    public String getDefaultFilterProcessesUrl() {
        return "/j_spring_openid_security_check";
    }

    protected boolean isAuthenticated(HttpServletRequest request) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null && auth.isAuthenticated();
    }

    protected boolean isOpenIdRequest(HttpServletRequest request) {
        String username = this.obtainUsername(request);
        return StringUtils.hasText((String)username) && username.toLowerCase().startsWith("http");
    }

    protected String obtainUsername(HttpServletRequest req) {
        return req.getParameter(this.claimedIdentityFieldName);
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        if (failed instanceof OpenIDAuthenticationRequiredException) {
            OpenIDAuthenticationRequiredException openIdAuthenticationRequiredException = (OpenIDAuthenticationRequiredException)failed;
            request.setAttribute((class$org$springframework$security$ui$openid$OpenIDAuthenticationRequiredException == null ? (class$org$springframework$security$ui$openid$OpenIDAuthenticationRequiredException = OpenIDAuthenticationProcessingFilter.class$("org.springframework.security.ui.openid.OpenIDAuthenticationRequiredException")) : class$org$springframework$security$ui$openid$OpenIDAuthenticationRequiredException).getName(), (Object)openIdAuthenticationRequiredException.getClaimedIdentity());
        }
    }

    public void setClaimedIdentityFieldName(String claimedIdentityFieldName) {
        this.claimedIdentityFieldName = claimedIdentityFieldName;
    }

    public void setConsumer(OpenIDConsumer consumer) {
        this.consumer = consumer;
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (((SpringSecurityFilter)this).logger.isDebugEnabled()) {
            ((SpringSecurityFilter)this).logger.debug((Object)"Updated SecurityContextHolder to contain null Authentication");
        }
        String failureUrl = this.determineFailureUrl(request, failed);
        if (((SpringSecurityFilter)this).logger.isDebugEnabled()) {
            ((SpringSecurityFilter)this).logger.debug((Object)("Authentication request failed: " + failed.toString()));
        }
        if (this.getAllowSessionCreation()) {
            try {
                request.getSession().setAttribute("SPRING_SECURITY_LAST_EXCEPTION", (Object)failed);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        super.getRememberMeServices().loginFail(request, response);
        this.sendRedirect(request, response, failureUrl);
    }

    public int getOrder() {
        return FilterChainOrder.OPENID_PROCESSING_FILTER;
    }

    public Map getRealmMapping() {
        return this.realmMapping;
    }

    public void setRealmMapping(Map realmMapping) {
        this.realmMapping = realmMapping;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

