/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method.aopalliance;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.security.intercept.method.MethodDefinitionSource;
import org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.springframework.util.Assert;

public class MethodDefinitionSourceAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private MethodDefinitionSource attributeSource;
    private MethodSecurityInterceptor interceptor;
    private Pointcut pointcut = new MethodDefinitionSourcePointcut();
    private BeanFactory beanFactory;
    private String adviceBeanName;
    private final Object adviceMonitor = new Object();
    static /* synthetic */ Class class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor;

    public MethodDefinitionSourceAdvisor(MethodSecurityInterceptor advice) {
        Assert.notNull((Object)advice.getObjectDefinitionSource(), (String)"Cannot construct a MethodDefinitionSourceAdvisor using a MethodSecurityInterceptor that has no ObjectDefinitionSource configured");
        this.interceptor = advice;
        this.attributeSource = advice.getObjectDefinitionSource();
    }

    public MethodDefinitionSourceAdvisor(String adviceBeanName, MethodDefinitionSource attributeSource) {
        Assert.notNull((Object)adviceBeanName, (String)"The adviceBeanName cannot be null");
        Assert.notNull((Object)attributeSource, (String)"The attributeSource cannot be null");
        this.adviceBeanName = adviceBeanName;
        this.attributeSource = attributeSource;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advice getAdvice() {
        Object object = this.adviceMonitor;
        synchronized (object) {
            if (this.interceptor == null) {
                Assert.notNull((Object)this.adviceBeanName, (String)"'adviceBeanName' must be set for use with bean factory lookup.");
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to resolve 'adviceBeanName'");
                this.interceptor = (MethodSecurityInterceptor)this.beanFactory.getBean(this.adviceBeanName, class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor == null ? (class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor = MethodDefinitionSourceAdvisor.class$("org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor")) : class$org$springframework$security$intercept$method$aopalliance$MethodSecurityInterceptor);
            }
            return this.interceptor;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InternalMethodInvocation
    implements MethodInvocation {
        private Method method;
        private Class targetClass;

        public InternalMethodInvocation(Method method, Class targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        protected InternalMethodInvocation() {
            throw new UnsupportedOperationException();
        }

        public Object[] getArguments() {
            throw new UnsupportedOperationException();
        }

        public Method getMethod() {
            return this.method;
        }

        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException();
        }

        public Object getThis() {
            return this.targetClass;
        }

        public Object proceed() throws Throwable {
            throw new UnsupportedOperationException();
        }
    }

    class MethodDefinitionSourcePointcut
    extends StaticMethodMatcherPointcut {
        MethodDefinitionSourcePointcut() {
        }

        public boolean matches(Method m, Class targetClass) {
            return MethodDefinitionSourceAdvisor.this.attributeSource.getAttributes(m, targetClass) != null;
        }
    }
}

