/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;

public final class ProxyGrantingTicketStorageImpl
implements ProxyGrantingTicketStorage {
    private static final long DEFAULT_TIMEOUT = 60000L;
    private final Map cache = new HashMap();

    public ProxyGrantingTicketStorageImpl() {
        this(60000L);
    }

    public ProxyGrantingTicketStorageImpl(long timeout) {
        ProxyGrantingTicketCleanupThread thread = new ProxyGrantingTicketCleanupThread(timeout, this.cache);
        thread.setDaemon(true);
        thread.start();
    }

    public String retrieve(String proxyGrantingTicketIou) {
        ProxyGrantingTicketHolder holder = (ProxyGrantingTicketHolder)this.cache.get(proxyGrantingTicketIou);
        if (holder == null) {
            return null;
        }
        this.cache.remove(holder);
        return holder.getProxyGrantingTicket();
    }

    public void save(String proxyGrantingTicketIou, String proxyGrantingTicket) {
        ProxyGrantingTicketHolder holder = new ProxyGrantingTicketHolder(proxyGrantingTicket);
        this.cache.put(proxyGrantingTicketIou, holder);
    }

    private final class ProxyGrantingTicketCleanupThread
    extends Thread {
        private final long timeout;
        private final Map cache;

        public ProxyGrantingTicketCleanupThread(long timeout, Map cache) {
            this.timeout = timeout;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ArrayList itemsToRemove = new ArrayList();
                Map map = this.cache;
                synchronized (map) {
                    Iterator<Object> iter = this.cache.keySet().iterator();
                    while (iter.hasNext()) {
                        Object key = iter.next();
                        ProxyGrantingTicketHolder holder = (ProxyGrantingTicketHolder)this.cache.get(key);
                        if (!holder.isExpired(this.timeout)) continue;
                        itemsToRemove.add(key);
                    }
                    iter = itemsToRemove.iterator();
                    while (iter.hasNext()) {
                        this.cache.remove(iter.next());
                    }
                }
            }
        }
    }

    private final class ProxyGrantingTicketHolder {
        private final String proxyGrantingTicket;
        private final long timeInserted;

        protected ProxyGrantingTicketHolder(String proxyGrantingTicket) {
            this.proxyGrantingTicket = proxyGrantingTicket;
            this.timeInserted = System.currentTimeMillis();
        }

        public String getProxyGrantingTicket() {
            return this.proxyGrantingTicket;
        }

        final boolean isExpired(long timeout) {
            return System.currentTimeMillis() - this.timeInserted > timeout;
        }
    }
}

