/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.Name;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;

public class RenameOperationExecutor
implements CompensatingTransactionOperationExecutor {
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$transaction$compensating$RenameOperationExecutor == null ? (class$org$springframework$ldap$transaction$compensating$RenameOperationExecutor = RenameOperationExecutor.class$("org.springframework.ldap.transaction.compensating.RenameOperationExecutor")) : class$org$springframework$ldap$transaction$compensating$RenameOperationExecutor));
    private LdapOperations ldapOperations;
    private Name newDn;
    private Name originalDn;
    static /* synthetic */ Class class$org$springframework$ldap$transaction$compensating$RenameOperationExecutor;

    public RenameOperationExecutor(LdapOperations ldapOperations, Name originalDn, Name newDn) {
        this.ldapOperations = ldapOperations;
        this.originalDn = originalDn;
        this.newDn = newDn;
    }

    public void rollback() {
        log.debug((Object)"Rolling back rename operation");
        try {
            this.ldapOperations.rename(this.newDn, this.originalDn);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to rollback rename operation. originalDn: " + this.newDn + "; newDn: " + this.originalDn));
        }
    }

    public void commit() {
        log.debug((Object)"Nothing to do in commit for rename operation");
    }

    public void performOperation() {
        log.debug((Object)"Performing rename operation");
        this.ldapOperations.rename(this.originalDn, this.newDn);
    }

    Name getNewDn() {
        return this.newDn;
    }

    LdapOperations getLdapOperations() {
        return this.ldapOperations;
    }

    Name getOriginalDn() {
        return this.originalDn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

