/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.saml;

import org.apache.xerces.dom.DocumentImpl;
import org.openxri.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Attribute {
    private String msName = "";
    private String msValue = "";

    public Attribute() {
    }

    public Attribute(Element oElem) {
        this.fromDOM(oElem);
    }

    public void reset() {
        this.msName = "";
        this.msValue = "";
    }

    public void fromDOM(Element oElem) {
        this.reset();
        if (oElem.hasAttributeNS(null, "Name")) {
            this.msName = oElem.getAttributeNS(null, "Name");
        }
        Element oChild = DOMUtils.getFirstChildElement(oElem);
        while (oChild != null) {
            if (oChild.getLocalName().equals("AttributeValue") && this.msValue.equals("") && oChild.getFirstChild() != null && oChild.getFirstChild().getNodeType() == 3) {
                this.msValue = oChild.getFirstChild().getNodeValue();
            }
            oChild = DOMUtils.getNextSiblingElement(oChild);
        }
    }

    public Element toDOM(Document oDoc) {
        if (oDoc == null) {
            return null;
        }
        Element oElem = oDoc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
        if (!this.msName.equals("")) {
            oElem.setAttributeNS(null, "Name", this.msName);
        }
        Element oValElem = oDoc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        oValElem.appendChild(oDoc.createTextNode(this.msValue));
        oElem.appendChild(oValElem);
        return oElem;
    }

    public String getName() {
        return this.msName;
    }

    public String getValue() {
        return this.msValue;
    }

    public void setValue(String sVal) {
        this.msValue = sVal;
    }

    public void setName(String sVal) {
        this.msName = sVal;
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toDOM((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }
}

