import grails.util.GrailsUtil

class BootStrap 
{
    //Required to be right here for Acegi plugin.
    def authenticateService
    Boolean BootStrapDemoDataSuccessful = true

    def init = { servletContext ->

    println "**** BootStrap GrailsUtil.environment = ${GrailsUtil.environment}"
    
        switch (GrailsUtil.environment)
        {
            case "development":
                        bootStrapDemoData()
                        break
            case "test":
                        break
            case "production":
                        bootStrapDemoData()
                        break 
        }
    
    }

    def destroy = {
    }

    //Insert some demo/startup data.
    void bootStrapDemoData()
    {
        println "BootStrapping demo data..."
    
        //TypeOfPersonGroup
	def personGroupTypeInstance
        personGroupTypeInstance = new PersonGroupType(name:"Department")
	BootStrapSaveAndTest(personGroupTypeInstance)
        personGroupTypeInstance = new PersonGroupType(name:"Contractor")
	BootStrapSaveAndTest(personGroupTypeInstance)
        personGroupTypeInstance = new PersonGroupType(name:"ProjectTeam")
	BootStrapSaveAndTest(personGroupTypeInstance)
    
        //PersonGroup
	def personGroupInstance
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Electrical")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Mechanical")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Production")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.get(2),
                        name:"Kewl AirCon Guys")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.get(3),
                        name:"gnuMims")
	BootStrapSaveAndTest(personGroupInstance)

        //Authority
        def authInstance

        authInstance = new Authority(description:"Application Admin",
                                        authority:"ROLE_ADMIN")
        BootStrapSaveAndTest(authInstance)

        authInstance = new Authority(description:"Application Admin",
                                        authority:"ROLE_USER")
        BootStrapSaveAndTest(authInstance)
            
        //Person
        def passwordEncoded = authenticateService.encodePassword("pass")
        def personInstance

        personInstance = new Person(loginName:"admin",
                                    firstName:"Admin",
                                    lastName:"Powers",
                                    password:passwordEncoded,
                                    email:"admin@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(1))
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToPersonGroups(PersonGroup.findByName("gnuMims"))

        personInstance = new Person(loginName:"user",
                                    firstName:"Demo",
                                    lastName:"Danza",
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToPersonGroups(PersonGroup.findByName("Electrical"))

        personInstance = new Person(loginName:"craig",
                                    firstName:"Craig",
                                    lastName:"SuperTech",
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToPersonGroups(PersonGroup.findByName("Electrical"))

        personInstance = new Person(loginName:"joe",
                                    firstName:"Joe",
                                    lastName:"Samples",
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToPersonGroups(PersonGroup.findByName("Mechanical"))

        personInstance = new Person(loginName:"mann",
                                    firstName:"Production",
                                    lastName:"Mann",
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToPersonGroups(PersonGroup.findByName("Production"))

        //TaskStatus
        def taskStatusInstance
    
        taskStatusInstance = new TaskStatus(name:"Not Started")
        BootStrapSaveAndTest(taskStatusInstance)

        taskStatusInstance = new TaskStatus(name:"In Progress")
        BootStrapSaveAndTest(taskStatusInstance)

        taskStatusInstance = new TaskStatus(name:"Completed")
        BootStrapSaveAndTest(taskStatusInstance)

        //TaskGroup
        def taskGroupInstance

        taskGroupInstance = new TaskGroup(name:"Engineering Activites",
                      description:"Engineering daily activities")
        BootStrapSaveAndTest(taskGroupInstance)

        taskGroupInstance = new TaskGroup(name:"Production Activites",
                      description:"Production daily activities")
        BootStrapSaveAndTest(taskGroupInstance)

        taskGroupInstance = new TaskGroup(name:"NewProject(s)",
                      description:" ")
        BootStrapSaveAndTest(taskGroupInstance)

        //Task
        def taskInstance

        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 leadPerson:Person.get(3),
                 description:"Check specific level sensor",
                 comment:"Has been noted as problematic, try recallibrating")
        BootStrapSaveAndTest(taskInstance)
        taskInstance.addToAssignedPersons(Person.get(1))
        taskInstance.addToAssignedPersons(Person.get(2))

        taskInstance = new Task(taskGroup:TaskGroup.findByName("Production Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 leadPerson:Person.get(5),
                 description:"Production Report",
                 comment:"Production report for specific production run or shift")
        BootStrapSaveAndTest(taskInstance)

        taskInstance = new Task(taskGroup:TaskGroup.findByName("NewProject(s)"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 leadPerson:Person.get(1),
                 description:"Make killer CMMS app",
                 comment:"Use Grails and get a move on!")
        BootStrapSaveAndTest(taskInstance)

        //EntryType
        def entryTypeInstance

        entryTypeInstance = new EntryType(name:"Fault")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"WorkDone")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"Production Report")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"Work Request")
        BootStrapSaveAndTest(entryTypeInstance)

        //ModificationType
        def modificationTypeInstance
        modificationTypeInstance = new ModificationType(name:"Created").save()
        modificationTypeInstance = new ModificationType(name:"Completed").save()
        modificationTypeInstance = new ModificationType(name:"Closed").save()
        modificationTypeInstance = new ModificationType(name:"Altered").save()
        modificationTypeInstance = new ModificationType(name:"TargetDateModified").save()
        modificationTypeInstance = new ModificationType(name:"ScheduledDateModified").save()
        modificationTypeInstance = new ModificationType(name:"DescriptionModified").save()
        modificationTypeInstance = new ModificationType(name:"AssignedToModified").save()
        modificationTypeInstance = new ModificationType(name:"NameModified").save()
        
        if(BootStrapDemoDataSuccessful) {
            println "BootStrapping demo data...successful."
        }
        else println "BootStrapping demo data...failed."
    }
    
    void BootStrapSaveAndTest(object) {
        if(!object.save()) {
            BootStrapDemoDataSuccessful = false
            println "'${object}' failed to save!"
            println object.errors

        }
    } 
}
