/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.tools.xrilookup;

import java.net.URL;
import java.net.URLConnection;
import org.openxri.resolve.MimeType;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.IllegalTrustTypeException;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.resolve.exception.XRIResolutionException;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class XRILookup {
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static final String CMD_HELP = "help";
    private static final String OPT_ROOT_EQUALS_URI = "-root_equals_auth";
    private static final String OPT_ROOT_AT_URI = "-root_at_auth";
    private static final String OPT_ROOT_BANG_URI = "-root_bang_auth";
    private static final String OPT_PROXY_URI = "-proxy";
    private static final String OPT_RES_MEDIA = "-xrd-r";
    private static final String OPT_RES_TYPE = "-xrd-t";
    private static final String OPT_MEDIA_TYPE = "-xrd-m";
    private static final String OPT_TRUST_TYPE = "-trust";
    private static final String OPT_FOLLOW_REFS = "-refs";
    private static final String OPT_SEP = "-sep";
    private static final String OPT_VERBOSE = "-verbose";
    private static final String OPT_NO_HEADER = "-no_header";
    private static final String ROOT_DEF_EQ_URI = "http://equal.xri.net";
    private static final String ROOT_DEF_AT_URI = "http://at.xri.net";
    private static final String ROOT_DEF_BANG_URI = "http://bang.xri.net";
    private static final String PROXY_URI = "http://xri.net";
    private static final String RES_MEDIA = "application/xrds+xml";
    private static final String TRUST_TYPE = "none";
    private static final String FOLLOW_REFS = "true";
    private static final String SEP_SELECT = "false";
    private String msTargetXRI;
    private boolean mbIsVerbose;
    private boolean mbDontOutputHeader;
    private String msRootEqualsURI;
    private String msRootAtURI;
    private String msRootBangURI;
    private String msProxyURI;
    private String xrdR = "application/xrds+xml";
    private String xrdT = null;
    private String xrdM = null;
    private TrustType trustType = new TrustType();
    private boolean followRefs = true;
    private boolean doSEP = false;

    public static void main(String[] oArgs) {
        StringBuffer sOutput = new StringBuffer();
        XRILookup oTraceRt = new XRILookup();
        int iResult = oTraceRt.process(sOutput, oArgs);
        XRILookup.exit(sOutput, iResult);
    }

    public int process(StringBuffer sOutput, String[] sArgs) {
        try {
            sOutput.setLength(0);
            this.msTargetXRI = null;
            this.mbIsVerbose = false;
            this.mbDontOutputHeader = false;
            this.msRootEqualsURI = ROOT_DEF_EQ_URI;
            this.msRootAtURI = ROOT_DEF_AT_URI;
            this.msRootBangURI = ROOT_DEF_BANG_URI;
            this.msProxyURI = null;
            try {
                this.setTrustType(TRUST_TYPE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (sArgs.length == 0) {
                this.outputPleaseTypeHelp(sOutput);
                return 1;
            }
            if (sArgs[0].equalsIgnoreCase(CMD_HELP)) {
                this.outputUsage(sOutput);
                return 0;
            }
            int iResult = this.scanArgs(sOutput, sArgs);
            if (iResult == 1) {
                return 1;
            }
            iResult = this.validateRootURIs(sOutput);
            if (iResult == 1) {
                return 1;
            }
            Resolver resolver = new Resolver();
            String trustParam = ";" + this.trustType.getParameterPair();
            XRD eqRoot = new XRD();
            Service eqAuthService = new Service();
            eqAuthService.addMediaType(RES_MEDIA + trustParam, "content", Boolean.FALSE);
            eqAuthService.addType("xri://$res*auth*($v*2.0)");
            eqAuthService.addURI(this.msRootEqualsURI);
            eqRoot.addService(eqAuthService);
            XRD atRoot = new XRD();
            Service atAuthService = new Service();
            atAuthService.addMediaType(RES_MEDIA + trustParam, "content", Boolean.FALSE);
            atAuthService.addType("xri://$res*auth*($v*2.0)");
            atAuthService.addURI(this.msRootAtURI);
            atRoot.addService(atAuthService);
            XRD bangRoot = new XRD();
            Service bangAuthService = new Service();
            bangAuthService.addMediaType(RES_MEDIA + trustParam, "content", Boolean.FALSE);
            bangAuthService.addType("xri://$res*auth*($v*2.0)");
            bangAuthService.addURI(this.msRootBangURI);
            bangRoot.addService(bangAuthService);
            resolver.setAuthority("=", eqRoot);
            resolver.setAuthority("@", atRoot);
            resolver.setAuthority("!", bangRoot);
            this.lookup(sOutput, resolver);
        }
        catch (Throwable oThrowable) {
            this.outputException(sOutput, oThrowable);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookup(StringBuffer sOutput, Resolver resolver) throws XRIResolutionException {
        String mediaTypeStr = this.xrdR + ";" + this.trustType.getParameterPair() + ";refs" + Boolean.toString(this.followRefs);
        if (this.msProxyURI != null) {
            mediaTypeStr = mediaTypeStr + ";sep" + Boolean.toString(this.doSEP);
        }
        MimeType resMediaType = MimeType.parse(mediaTypeStr);
        ResolverState state = new ResolverState();
        XRDS xrds = null;
        XRD xrd = null;
        try {
            if (this.doSEP) {
                if (resMediaType.isType("text/uri-list")) {
                    String text = resolver.resolveSEPToTextURIList(this.msTargetXRI.toString(), this.trustType, this.xrdT, this.xrdM, this.followRefs, state);
                    if (text.length() <= 0) {
                        sOutput.append("ERROR: SEP_NOT_FOUND(code=241): no url found\n");
                    } else {
                        sOutput.append(text);
                    }
                } else if (resMediaType.isType(RES_MEDIA)) {
                    xrds = resolver.resolveSEPToXRDS(this.msTargetXRI, this.trustType, this.xrdT, this.xrdM, this.followRefs, state);
                    sOutput.append(xrds.toString());
                } else if (resMediaType.isType("application/xrd+xml")) {
                    xrd = resolver.resolveSEPToXRD(this.msTargetXRI, this.trustType, this.xrdT, this.xrdM, this.followRefs, state);
                    sOutput.append(xrd.toResultString());
                } else {
                    sOutput.append("Unknown resolution media type (sep=true)");
                }
            } else if (resMediaType.isType(RES_MEDIA)) {
                xrds = resolver.resolveAuthToXRDS(this.msTargetXRI, this.trustType, this.followRefs, state);
                sOutput.append(xrds.toString());
            } else if (resMediaType.isType("application/xrd+xml")) {
                xrd = resolver.resolveAuthToXRD(this.msTargetXRI, this.trustType, this.followRefs, state);
                sOutput.append(xrd.toString());
            } else if (resMediaType.isType("text/uri-list")) {
                sOutput.append("ERROR: text/uri-list must only be used with service selection (sep=true)\n");
            } else {
                sOutput.append("ERROR: Unknown resolution media type (sep=false)");
            }
        }
        catch (PartialResolutionException pre) {
            xrds = pre.getPartialXRDS();
            xrd = xrds.getFinalXRD();
            if (resMediaType == null || resMediaType.isType("text/uri-list")) {
                sOutput.append("ERROR: resolution failed. Partial XRDS:\n" + xrds.toString());
            } else if (resMediaType.isType(RES_MEDIA)) {
                sOutput.append("ERROR: resolution failed. Partial XRDS:\n" + xrds.toString());
            } else if (resMediaType.isType("application/xrd+xml")) {
                sOutput.append("ERROR: resolution failed. Partial XRDS:\n" + xrds.toString());
            }
        }
        finally {
            if (this.mbIsVerbose) {
                sOutput.append("\n\nSTATISTICS:\n" + state.toString() + "\n");
            }
        }
    }

    private int scanArgs(StringBuffer sOutput, String[] sArgs) {
        for (int i = 0; i < sArgs.length; ++i) {
            String sArg = sArgs[i];
            if (!this.isOption(sArg)) {
                if (this.msTargetXRI == null) {
                    this.msTargetXRI = sArg;
                    continue;
                }
                this.outputPleaseTypeHelp(sOutput);
                return 1;
            }
            if (sArg.equalsIgnoreCase(OPT_VERBOSE)) {
                this.mbIsVerbose = true;
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_ROOT_AT_URI)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_ROOT_AT_URI);
                    return 1;
                }
                this.msRootAtURI = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_ROOT_EQUALS_URI)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_ROOT_EQUALS_URI);
                    return 1;
                }
                this.msRootEqualsURI = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_ROOT_BANG_URI)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_ROOT_BANG_URI);
                    return 1;
                }
                this.msRootBangURI = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_PROXY_URI)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_PROXY_URI);
                    return 1;
                }
                this.msProxyURI = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_RES_MEDIA)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_RES_MEDIA);
                    return 1;
                }
                this.xrdR = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_RES_TYPE)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_RES_TYPE);
                    return 1;
                }
                this.xrdT = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_MEDIA_TYPE)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_MEDIA_TYPE);
                    return 1;
                }
                this.xrdM = sArgs[i];
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_TRUST_TYPE)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_TRUST_TYPE);
                    return 1;
                }
                try {
                    this.setTrustType(sArgs[i]);
                    continue;
                }
                catch (IllegalTrustTypeException e) {
                    System.err.println("Trust type '" + sArgs[i] + "' is not valid: " + e);
                    return 1;
                }
            }
            if (sArg.equalsIgnoreCase(OPT_FOLLOW_REFS)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_FOLLOW_REFS);
                    return 1;
                }
                this.followRefs = sArgs[i].toLowerCase().equals(FOLLOW_REFS);
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_SEP)) {
                if (i == sArgs.length || this.isOption(sArgs[++i])) {
                    this.outputOptionRequiresArgument(sOutput, OPT_SEP);
                    return 1;
                }
                this.doSEP = sArgs[i].toLowerCase().equals(FOLLOW_REFS);
                continue;
            }
            if (sArg.equalsIgnoreCase(OPT_NO_HEADER)) {
                this.mbDontOutputHeader = true;
                continue;
            }
            sOutput.append("Invalid option: " + sArg + "\n");
            this.outputPleaseTypeHelp(sOutput);
            return 1;
        }
        if (this.msTargetXRI == null) {
            sOutput.append("Must specify target XRI. \n");
            this.outputPleaseTypeHelp(sOutput);
            return 1;
        }
        return 0;
    }

    private int validateRootURIs(StringBuffer sOutput) {
        String sCurURI = null;
        try {
            sCurURI = this.msRootEqualsURI;
            URL oURL = new URL(sCurURI);
            URLConnection oConn = oURL.openConnection();
            oConn.connect();
            sCurURI = this.msRootAtURI;
            oURL = new URL(sCurURI);
            oConn = oURL.openConnection();
            oConn.connect();
            sCurURI = this.msRootBangURI;
            oURL = new URL(sCurURI);
            oConn = oURL.openConnection();
            oConn.connect();
        }
        catch (Throwable oThrowable) {
            sOutput.append("Cannot connect to root authority URI: " + sCurURI);
            return 1;
        }
        return 0;
    }

    private void outputUsage(StringBuffer sOutput) {
        sOutput.append("\nusage: 1. xrilookup <XRI> [options] \n       2. xrilookup help \n\nThe first form resolves the first segment of the given <XRI> and outputs information about the final authority \n\nExample usage: xrilookup xri://@community*member*family \n\nRefer to the OASIS document \"Extensible Resource Identifier (XRI) \nResolution\" for information about XRI resolution. \n\nThe second form generates this help message. \n\nAvailable options: \n    -root_equals_auth <URI>: Root authority URI for '=' resolution. \n    -root_at_auth <URI>:     Root authority URI for '@' resolution. \n    -root_bang_auth <URI>:   Root authority URI for '!' resolution. \n    -proxy <URI>:            Proxy URI (root authorities will not be used.\n\n    -xrd-r <return-media-type>: corresponds to _xrd_r\n    -xrd-t <service-type>: corresponds to _xrd_t\n    -xrd-m <service-media-type>: corresponds to _xrd_m\n    -trust (none|https|saml|saml+https)\n    -refs (true|false): Flag to indicate if Refs should be followed.\n    -sep (true|false): Flag to indicate if SEP selection should be done.\n    -verbose:        Print verbose output. \n    -no_header:      Omit header from non-verbose output. \n\nThe default value (used if unspecified) for the three '-root_' options are:\n    -root_equals_auth http://equal.xri.net. \n    -root_at_auth     http://at.xri.net. \n    -root_bang_auth   http://bang.xri.net. \n    -proxy            http://xri.net.\n    -xrd-r " + this.xrdR + "\n" + "    " + OPT_RES_TYPE + " " + this.xrdT + "\n" + "    " + OPT_MEDIA_TYPE + " " + this.xrdM + "\n" + "    " + OPT_TRUST_TYPE + " " + this.trustType.toString() + "\n" + "    " + OPT_FOLLOW_REFS + " " + Boolean.toString(this.followRefs) + "\n" + "    " + OPT_SEP + " " + Boolean.toString(this.doSEP) + "\n" + "\n" + "Program output: \n" + "    For successful invocation, 0 is returned with program \n" + "    output on stdout. Otherwise 1 is returned with error \n" + "    message output on stderr. \n" + "\n" + "N.B.: \n" + "    The server script \"regexample\" can be used to register \n" + "    subsegments and create authorities. \n " + "\n" + "\n");
    }

    private boolean isOption(String sArg) {
        return sArg.charAt(0) == '-';
    }

    private void outputPleaseTypeHelp(StringBuffer sOutput) {
        sOutput.append("Type \"xrilookup help\". \n");
    }

    private void outputOptionRequiresArgument(StringBuffer sOutput, String sOption) {
        sOutput.append("Option: " + sOption + " requires argument.\n");
        this.outputPleaseTypeHelp(sOutput);
    }

    void outputChars(StringBuffer sOutput, char c, int num) {
        char[] cArray = new char[num];
        for (int i = 0; i < num; ++i) {
            cArray[i] = c;
        }
        sOutput.append(cArray);
    }

    private void outputException(StringBuffer sOutput, Throwable oThrowable) {
        String message = oThrowable.getLocalizedMessage();
        sOutput.append(oThrowable.getClass().getName() + ": " + message + "\n");
        if (this.mbIsVerbose) {
            oThrowable.printStackTrace();
        }
    }

    private static void exit(StringBuffer sOutput, int iStatus) {
        if (iStatus == 1) {
            System.err.print(sOutput);
        } else {
            System.out.print(sOutput);
        }
        System.exit(iStatus);
    }

    protected void setTrustType(String type) throws IllegalTrustTypeException {
        this.trustType.setType(type);
    }
}

