/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import java.util.Iterator;
import java.util.Vector;
import org.openxri.IRIUtils;
import org.openxri.Parsable;
import org.openxri.ParseStream;
import org.openxri.SubSegment;

public class XRISegment
extends Parsable {
    private Vector moSubSegments = null;
    private boolean mbAllowImpliedDelimiter = true;
    private boolean mbAllowColon = true;
    private boolean mbAllowReassignable = true;

    XRISegment(boolean bAllowImpliedDelimiter, boolean bAllowColon, boolean bAllowReassignable) {
        this.mbAllowImpliedDelimiter = bAllowImpliedDelimiter;
        this.mbAllowColon = bAllowColon;
        this.mbAllowReassignable = bAllowReassignable;
    }

    public XRISegment(String sVal) {
        super(sVal);
        this.parse();
    }

    public XRISegment(String sVal, boolean bAllowImpliedDelimiter, boolean bAllowColon) {
        super(sVal);
        this.mbAllowImpliedDelimiter = bAllowImpliedDelimiter;
        this.mbAllowColon = bAllowColon;
        this.parse();
    }

    public int getNumSubSegments() {
        this.parse();
        return this.moSubSegments == null ? 0 : this.moSubSegments.size();
    }

    public Iterator getSubSegmentIterator() {
        this.parse();
        return this.moSubSegments == null ? null : this.moSubSegments.iterator();
    }

    public SubSegment getSubSegmentAt(int nIndex) {
        this.parse();
        if (this.moSubSegments == null || nIndex >= this.moSubSegments.size()) {
            return null;
        }
        return (SubSegment)this.moSubSegments.elementAt(nIndex);
    }

    public XRISegment getParent() {
        this.parse();
        if (this.moSubSegments == null || this.moSubSegments.size() <= 1) {
            return null;
        }
        XRISegment oParent = new XRISegment(this.mbAllowImpliedDelimiter, this.mbAllowColon, this.mbAllowReassignable);
        oParent.msValue = "";
        oParent.moSubSegments = new Vector();
        oParent.mbParsed = true;
        oParent.mbParseResult = this.mbParseResult;
        for (int i = 0; i < this.moSubSegments.size() - 1; ++i) {
            SubSegment oSubseg = (SubSegment)this.moSubSegments.elementAt(i);
            oParent.moSubSegments.add(oSubseg);
            oParent.msValue = oParent.msValue + oSubseg.toString();
        }
        return oParent;
    }

    public XRISegment getRemainder(int nSkip) {
        this.parse();
        if (this.moSubSegments == null || this.moSubSegments.size() <= nSkip) {
            return null;
        }
        XRISegment oRemainder = new XRISegment(false, this.mbAllowColon, this.mbAllowReassignable);
        oRemainder.msValue = "";
        oRemainder.moSubSegments = new Vector();
        oRemainder.mbParsed = true;
        oRemainder.mbParseResult = this.mbParseResult;
        for (int i = nSkip; i < this.moSubSegments.size(); ++i) {
            SubSegment oSubseg = (SubSegment)this.moSubSegments.elementAt(i);
            oRemainder.moSubSegments.add(oSubseg);
            oRemainder.msValue = oRemainder.msValue + oSubseg.toString();
        }
        return oRemainder;
    }

    public String toString() {
        this.parse();
        StringBuffer sRetval = new StringBuffer();
        for (int i = 0; i < this.moSubSegments.size(); ++i) {
            sRetval.append(((SubSegment)this.moSubSegments.elementAt(i)).toString());
        }
        return sRetval.toString();
    }

    boolean doScan(ParseStream oXRISegStream) {
        this.moSubSegments = new Vector();
        boolean bAllowImpliedDelimiter = this.mbAllowImpliedDelimiter;
        boolean bAllowReassignable = this.mbAllowReassignable;
        while (!oXRISegStream.empty()) {
            SubSegment oSubSegment;
            char c = oXRISegStream.getData().charAt(0);
            if (!bAllowReassignable && c != '!' || !(oSubSegment = new SubSegment(bAllowImpliedDelimiter, this.mbAllowColon)).scan(oXRISegStream)) break;
            this.moSubSegments.add(oSubSegment);
            bAllowImpliedDelimiter = false;
            bAllowReassignable = true;
        }
        if (this.moSubSegments.size() > 0) {
            return true;
        }
        this.moSubSegments = null;
        return false;
    }

    public String toIRINormalForm(boolean wantOptionalDelim) {
        String sValue = "";
        boolean first = true;
        Iterator oIt = this.moSubSegments.iterator();
        while (oIt.hasNext()) {
            sValue = sValue + ((SubSegment)oIt.next()).toIRINormalForm(wantOptionalDelim || !first);
            first = false;
        }
        return sValue;
    }

    public String toIRINormalForm() {
        return this.toIRINormalForm(false);
    }

    public String toURINormalForm(boolean wantOptionalDelim) {
        return IRIUtils.IRItoURI(this.toIRINormalForm(wantOptionalDelim));
    }

    public String toURINormalForm() {
        return this.toURINormalForm(false);
    }

    public boolean equals(XRISegment segment) {
        return this.toString().equals(segment.toString());
    }

    public boolean equalsIgnoreCase(XRISegment segment) {
        return this.toString().equalsIgnoreCase(segment.toString());
    }

    public boolean isPrefixOf(XRISegment segment) {
        int n = this.getNumSubSegments();
        if (n > segment.getNumSubSegments()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            SubSegment subseg = this.getSubSegmentAt(i);
            if (subseg.equalsIgnoreCase(segment.getSubSegmentAt(i))) continue;
            return false;
        }
        return true;
    }
}

