/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.annotation.Jsr250SecurityConfig;
import org.springframework.security.intercept.method.AbstractFallbackMethodDefinitionSource;

public class Jsr250MethodDefinitionSource
extends AbstractFallbackMethodDefinitionSource {
    protected ConfigAttributeDefinition findAttributes(Class clazz) {
        return this.processAnnotations(clazz.getAnnotations());
    }

    protected ConfigAttributeDefinition findAttributes(Method method, Class targetClass) {
        return this.processAnnotations(AnnotationUtils.getAnnotations((Method)method));
    }

    public Collection getConfigAttributeDefinitions() {
        return null;
    }

    private ConfigAttributeDefinition processAnnotations(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation a : annotations) {
            if (a instanceof DenyAll) {
                return new ConfigAttributeDefinition((ConfigAttribute)Jsr250SecurityConfig.DENY_ALL_ATTRIBUTE);
            }
            if (a instanceof PermitAll) {
                return new ConfigAttributeDefinition((ConfigAttribute)Jsr250SecurityConfig.PERMIT_ALL_ATTRIBUTE);
            }
            if (!(a instanceof RolesAllowed)) continue;
            RolesAllowed ra = (RolesAllowed)a;
            ArrayList<Jsr250SecurityConfig> attributes = new ArrayList<Jsr250SecurityConfig>();
            for (String allowed : ra.value()) {
                attributes.add(new Jsr250SecurityConfig(allowed));
            }
            return new ConfigAttributeDefinition(attributes);
        }
        return null;
    }
}

