/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.util;

import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOM3Utils {
    private static boolean sbHasDOM3Support = false;

    public static boolean hasDOM3Support() {
        return sbHasDOM3Support;
    }

    public static boolean isXercesDocument(Document oDoc) {
        return oDoc.getClass().getName().startsWith("org.apache.xerces.dom");
    }

    public static void bestEffortAdopt(Document oDoc, Node oNode) {
        if (oDoc == null || oNode == null || oNode.getOwnerDocument() == oDoc) {
            return;
        }
        if (DOM3Utils.hasDOM3Support()) {
            oDoc.adoptNode(oNode);
            return;
        }
        if (DOM3Utils.isXercesDocument(oDoc)) {
            ((DocumentImpl)oDoc).adoptNode(oNode);
            return;
        }
        oDoc.importNode(oNode, true);
    }

    public static void bestEffortSetIDAttr(Element oElem, String sNS, String sAttr) {
        if (oElem == null || sAttr == null) {
            return;
        }
        if (DOM3Utils.hasDOM3Support()) {
            Attr oAttr = oElem.getAttributeNodeNS(sNS, sAttr);
            oElem.setIdAttributeNode(oAttr, true);
            return;
        }
        if (DOM3Utils.isXercesDocument(oElem.getOwnerDocument())) {
            String sAttrVal = oElem.getAttributeNS(sNS, sAttr);
            ((DocumentImpl)oElem.getOwnerDocument()).putIdentifier(sAttrVal, oElem);
            return;
        }
        throw new RuntimeException("No known method to set a signable ID attribute. Try using a DOM3-compliant Parser or a DOM2 Xerces Document.");
    }

    static {
        try {
            Document.class.getDeclaredMethod("adoptNode", Node.class);
            sbHasDOM3Support = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

