/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.basicauth.BasicProcessingFilter;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.util.Assert;

public class RememberMeServicesInjectionBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private ListableBeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$security$ui$rememberme$RememberMeServices;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractProcessingFilter) {
            AbstractProcessingFilter pf = (AbstractProcessingFilter)bean;
            if (pf.getRememberMeServices() == null) {
                this.logger.info((Object)("Setting RememberMeServices on bean " + beanName));
                pf.setRememberMeServices(this.getRememberMeServices());
            }
        } else if ("_basicAuthenticationFilter".equals(beanName)) {
            BasicProcessingFilter bf = (BasicProcessingFilter)bean;
            this.logger.info((Object)("Setting RememberMeServices on bean " + beanName));
            bf.setRememberMeServices(this.getRememberMeServices());
        }
        return bean;
    }

    private RememberMeServices getRememberMeServices() {
        Map beans = this.beanFactory.getBeansOfType(class$org$springframework$security$ui$rememberme$RememberMeServices == null ? (class$org$springframework$security$ui$rememberme$RememberMeServices = RememberMeServicesInjectionBeanPostProcessor.class$("org.springframework.security.ui.rememberme.RememberMeServices")) : class$org$springframework$security$ui$rememberme$RememberMeServices);
        Assert.isTrue((beans.size() > 0 ? 1 : 0) != 0, (String)"No RememberMeServices configured");
        Assert.isTrue((beans.size() == 1 ? 1 : 0) != 0, (String)"Use of '<remember-me />' requires a single instance of RememberMeServices in the application context, but more than one was found.");
        return (RememberMeServices)beans.values().toArray()[0];
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

