/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.IRIUtils;
import org.openxri.Parsable;
import org.openxri.ParseStream;
import org.openxri.RelativeXRI;
import org.openxri.XRI;
import org.openxri.XRIReference;

public class XRef
extends Parsable {
    XRIReference moXRIRef;
    String msIRI;

    public XRef(String sPath) {
        super(sPath);
        this.parse();
    }

    XRef() {
    }

    boolean doScan(ParseStream oStream) {
        if (oStream.empty()) {
            return false;
        }
        if (oStream.getData().charAt(0) != '(') {
            return false;
        }
        ParseStream oTempStream = oStream.begin();
        oTempStream.consume(1);
        String sIRI = null;
        XRIReference oRef = XRef.scanXRIReference(oTempStream);
        if (oRef == null && (sIRI = XRef.scanIRI(oTempStream)) == null) {
            return false;
        }
        if (oTempStream.empty() || oTempStream.getData().charAt(0) != ')') {
            return false;
        }
        oTempStream.consume(1);
        oStream.end(oTempStream);
        this.moXRIRef = oRef;
        this.msIRI = sIRI;
        return true;
    }

    static XRIReference scanXRIReference(ParseStream oStream) {
        XRI oXRI = new XRI();
        if (oXRI.scan(oStream)) {
            return oXRI;
        }
        RelativeXRI oRelXRI = new RelativeXRI();
        if (oRelXRI.scan(oStream)) {
            return oRelXRI;
        }
        return null;
    }

    static String scanIRI(ParseStream oStream) {
        return null;
    }

    public XRIReference getXRIReference() {
        this.parse();
        return this.moXRIRef;
    }

    public String getIRI() {
        this.parse();
        return this.msIRI;
    }

    public String toIRINormalForm() {
        return IRIUtils.XRItoIRI(this.toString(), true);
    }

    public String toURINormalForm() {
        return IRIUtils.IRItoURI(this.toIRINormalForm());
    }
}

