/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.saml;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Conditions {
    private static Log soLog = LogFactory.getLog((String)Conditions.class.getName());
    private Date moNotBefore = null;
    private Date moNotAfter = null;

    public Conditions() {
    }

    public Conditions(Element oElem) {
        this.fromDOM(oElem);
    }

    public String toString() {
        return this.dump("");
    }

    public String dump(String sTab) {
        return "";
    }

    public void reset() {
        this.moNotBefore = null;
        this.moNotAfter = null;
    }

    public void fromDOM(Element oElem) {
        String sVal;
        this.reset();
        if (oElem.hasAttributeNS(null, "NotBefore")) {
            sVal = oElem.getAttributeNS(null, "NotBefore");
            try {
                this.moNotBefore = DOMUtils.fromXMLDateTime(sVal);
            }
            catch (ParseException oEx) {
                soLog.warn((Object)"Caught exception on notBefore time", (Throwable)oEx);
            }
        }
        if (oElem.hasAttributeNS(null, "NotOnOrAfter")) {
            sVal = oElem.getAttributeNS(null, "NotOnOrAfter");
            try {
                this.moNotAfter = DOMUtils.fromXMLDateTime(sVal);
            }
            catch (ParseException oEx) {
                soLog.warn((Object)"Caught exception on notAfter time", (Throwable)oEx);
            }
        }
    }

    public boolean isValid() {
        Date oNow = new Date();
        if (this.moNotBefore != null && oNow.before(this.moNotBefore)) {
            return false;
        }
        return this.moNotAfter == null || !oNow.after(this.moNotAfter);
    }

    public Element toDOM(Document oDoc) {
        if (oDoc == null) {
            return null;
        }
        Element oElem = oDoc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "Conditions");
        return oElem;
    }

    public Date getNotAfter() {
        return this.moNotAfter;
    }

    public void setNotAfter(Date oVal) {
        this.moNotAfter = oVal;
    }

    public Date getNotBefore() {
        return this.moNotBefore;
    }

    public void setNotBefore(Date oVal) {
        this.moNotBefore = oVal;
    }
}

