/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpHeader {
    private HttpHeader() {
    }

    public static String getRequestHeader(HttpURLConnection connection) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(connection.getRequestMethod());
        buffer.append(" ");
        buffer.append(connection.getURL());
        buffer.append(" HTTP/1.1\n");
        Map<String, List<String>> map = connection.getRequestProperties();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            List<String> items = map.get(key);
            buffer.append(key);
            buffer.append(": ");
            for (int i = 0; i < items.size(); ++i) {
                if (0 != i) {
                    buffer.append(", ");
                }
                buffer.append((Object)items.get(i));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String getResponseHeader(HttpURLConnection conn) {
        StringBuffer buffer = new StringBuffer(1024);
        try {
            int code = conn.getResponseCode();
            if (-1 != code) {
                String value;
                String message = conn.getResponseMessage();
                int i = 0;
                while (null != (value = conn.getHeaderField(i))) {
                    String key = conn.getHeaderFieldKey(i);
                    if (null == key && 0 == i) {
                        buffer.append("HTTP/1.1 ");
                        buffer.append(code);
                        buffer.append(" ");
                        buffer.append(message);
                        buffer.append("\n");
                    } else {
                        if (null != key) {
                            buffer.append(key);
                            buffer.append(": ");
                        }
                        buffer.append(value);
                        buffer.append("\n");
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            buffer.append(ioe.toString());
        }
        return buffer.toString();
    }
}

