/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.FacebookJaxbRestClient;
import com.google.code.facebookapi.FacebookJsonRestClient;
import com.google.code.facebookapi.FacebookParam;
import com.google.code.facebookapi.FacebookSignatureUtil;
import com.google.code.facebookapi.FacebookXmlRestClient;
import com.google.code.facebookapi.IFacebookRestClient;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookWebRequest<T> {
    protected static Log log = LogFactory.getLog(FacebookWebRequest.class);
    private HttpServletRequest request;
    private String apiKey;
    private String secret;
    private IFacebookRestClient<T> apiClient;
    private boolean valid;
    private Map<String, String> fbParams;
    private String sessionKey;
    private Long userId;
    private Long sessionExpires;
    @Deprecated
    private boolean appAdded;
    private boolean appUser;
    private boolean inCanvas;
    private boolean inIframe;
    private boolean inNewFacebook;
    private boolean inProfileTab;

    public static FacebookWebRequest<Document> newInstanceXml(HttpServletRequest request, String apiKey, String secret) {
        return new FacebookWebRequest<Document>(request, apiKey, secret, new FacebookXmlRestClient(apiKey, secret));
    }

    public static FacebookWebRequest<Object> newInstanceJson(HttpServletRequest request, String apiKey, String secret) {
        return new FacebookWebRequest<Object>(request, apiKey, secret, new FacebookJsonRestClient(apiKey, secret));
    }

    public static FacebookWebRequest<Object> newInstanceJaxb(HttpServletRequest request, String apiKey, String secret) {
        return new FacebookWebRequest<Object>(request, apiKey, secret, new FacebookJaxbRestClient(apiKey, secret));
    }

    protected FacebookWebRequest(HttpServletRequest request, String apiKey, String secret, IFacebookRestClient<T> apiClient) {
        this.request = request;
        this.apiKey = apiKey;
        this.secret = secret;
        this.apiClient = apiClient;
        this.fbParams = FacebookSignatureUtil.pulloutFbSigParams(request.getParameterMap());
        this.valid = FacebookSignatureUtil.verifySignature(this.fbParams, secret);
        if (this.valid) {
            String friends;
            this.inNewFacebook = this.getFbParamBoolean(FacebookParam.IN_NEW_FACEBOOK);
            this.inProfileTab = this.getFbParamBoolean(FacebookParam.IN_PROFILE_TAB);
            if (!this.inProfileTab) {
                this.sessionKey = this.getFbParam(FacebookParam.SESSION_KEY);
                this.userId = this.getFbParamLong(FacebookParam.USER);
                Long canvas_user = this.getFbParamLong(FacebookParam.CANVAS_USER);
                if (canvas_user != null) {
                    this.userId = canvas_user;
                }
            } else {
                this.sessionKey = this.getFbParam(FacebookParam.PROFILE_SESSION_KEY);
                this.userId = this.getFbParamLong(FacebookParam.PROFILE_USER);
            }
            this.sessionExpires = this.getFbParamLong(FacebookParam.EXPIRES);
            if (this.sessionKey != null || this.userId != null) {
                apiClient.setCacheSession(this.sessionKey, this.userId, this.sessionExpires);
            }
            if ((friends = this.getFbParam(FacebookParam.FRIENDS)) != null && !friends.equals("")) {
                ArrayList<Long> friendsList = new ArrayList<Long>();
                for (String friend : friends.split(",")) {
                    friendsList.add(Long.parseLong(friend));
                }
                apiClient.setCacheFriendsList(friendsList);
            }
            this.appAdded = this.getFbParamBoolean(FacebookParam.ADDED);
            apiClient.setCacheAppAdded(this.appAdded);
            this.appUser = this.getFbParamBoolean(FacebookParam.ADDED);
            apiClient.setCacheAppUser(this.appUser);
            this.inCanvas = this.getFbParamBoolean(FacebookParam.IN_CANVAS);
            this.inIframe = this.getFbParamBoolean(FacebookParam.IN_IFRAME) || !this.inCanvas;
        }
    }

    public String getFbParam(FacebookParam key) {
        return this.fbParams.get(key.toString());
    }

    public Long getFbParamLong(FacebookParam key) {
        String t = this.getFbParam(key);
        if (t != null) {
            return Long.parseLong(t);
        }
        return null;
    }

    public boolean getFbParamBoolean(FacebookParam key) {
        Long t = this.getFbParamLong(key);
        return t != null && t > 0L;
    }

    public boolean fbParamEquals(FacebookParam key, String val) {
        String param = this.getFbParam(key);
        return key.equals(param);
    }

    public boolean isLoggedIn() {
        return this.sessionKey != null && this.userId != null;
    }

    public IFacebookRestClient<T> getApiClient() {
        return this.apiClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Deprecated
    public boolean isAppAdded() {
        return this.appAdded;
    }

    public boolean isAppUser() {
        return this.appUser;
    }

    public Map<String, String> getFbParams() {
        return this.fbParams;
    }

    public boolean isInCanvas() {
        return this.inCanvas;
    }

    public boolean isInIframe() {
        return this.inIframe;
    }

    public Long getSessionExpires() {
        return this.sessionExpires;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public Long getUserId() {
        return this.userId;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInNewFacebook() {
        return this.inNewFacebook;
    }

    public boolean isInProfileTab() {
        return this.inProfileTab;
    }
}

