

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show AssetSubItem</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <div class="dialog">
                <table>
                    <tbody>
                        
                        <tr class="prop">
                            <td valign="top" class="groupHeader">
                                <label for="name">Asset Sub Item</label>
                            </td>
                            <td valign="top" class="value">
                            </td>
                        </tr>

                    
                        <tr class="prop">
                            <td valign="top" class="groupName">Id:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:assetSubItemInstance, field:'id')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="groupName">Name:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:assetSubItemInstance, field:'name')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="groupName">Description:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:assetSubItemInstance, field:'description')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="groupName">Comment:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:assetSubItemInstance, field:'comment')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="groupName">Is Active:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:assetSubItemInstance, field:'isActive')}</td>
                            
                        </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="groupHeader">Extended Attributes</td>
                            <td  valign="top" style="text-align:left;" class="value">
                            </td>
                        </tr>
                        
                        <g:each var="a" in="${assetSubItemInstance.assetSubItemExtendedAttributes.sort { p1, p2 -> p1.extendedAttributeType.name.compareToIgnoreCase(p2.extendedAttributeType.name) }}">
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    ${a.extendedAttributeType.name.encodeAsHTML()}:
                                </td>

                                <td  valign="top" style="text-align:left;" class="value">
                                    <g:link controller="assetSubItemExtendedAttributeDetailed" action="edit" id="${a.id}">
                                        ${a.value.encodeAsHTML()}
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        
                        <tr class="prop">
                            <td valign="top" class="groupHeader">
                                <label for="name">Asset Tree</label>
                            </td>
                            <td valign="top" class="value">
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="groupName">Assets:</td>

                            <td  valign="top" style="text-align:left;" class="value">
                                <g:if test="${assetSubItemInstance.parentItem}" >
                                    N/A (Assigned to parent item)
                                </g:if>
                                <g:else>
                                    <g:if test="${assetSubItemInstance.assets}">
                                        <ul>
                                        <g:each var="a" in="${ assetSubItemInstance.assets.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                            <li><g:link controller="assetDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                        </g:each>
                                        </ul>
                                    </g:if>
                                    <g:else>
                                        May be assigned via asset edit view.
                                    </g:else>
                                </g:else>
                            </td>

                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="groupName">Parent Item:</td>
                            
                            <td valign="top" class="value">
                                <g:if test="${assetSubItemInstance.assets}">
                                     Level 1 sub item (Assigned directly to assets)
                                </g:if>
                                <g:else>
                                    <g:link controller="assetSubItemDetailed" action="show" id="${assetSubItemInstance?.parentItem?.id}">
                                        ${assetSubItemInstance?.parentItem?.encodeAsHTML()}
                                    </g:link>
                                </g:else>
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="groupName">Sub Items:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="s" in="${assetSubItemInstance.subItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                    <li><g:link controller="assetSubItemDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="groupHeader">
                                <label for="name">Maintenance Actions</label>
                            </td>
                            <td valign="top" class="value">
                            </td>
                        </tr>
                    
                        <g:each var="m" in="${assetSubItemInstance.maintenanceActions}">
                            <tr class="prop">
                                <td valign="top" class="name"></td>
                                <td  valign="top" style="text-align:left;" class="value">
                                    <g:link controller="maintenanceActionDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link>
                                </td>
                            </tr>
                        </g:each>
                    
                    </tbody>
                </table>
            </div>
            <div class="buttons">
                <g:form>
                    <input type="hidden" name="id" value="${assetSubItemInstance?.id}" />
                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </g:form>
            </div>
        </div>
    </body>
</html>
