import org.apache.commons.collections.list.LazyList
import org.apache.commons.collections.FactoryUtils

class TaskProcedureRevision {

    Task linkedTask

    TaskProcedure taskProcedure
    Integer revision
    Person createdBy
    Date dateCreated = new Date() // autoTimestamp

    def getDescription() { linkedTask.description }
    def getAsset() { linkedTask.primaryAsset }

    List maintenanceActions = new ArrayList()
    List documentReferences = new ArrayList()

    static hasMany = [tasks: Task,
                                    maintenanceActions: MaintenanceAction,
                                    documentReferences: DocumentReference]

    def getMaintenanceActionLazyList() {
        return LazyList.decorate(maintenanceActions, FactoryUtils.instantiateFactory(MaintenanceAction.class))
    }

    def getDocumentReferenceLazyList() {
        return LazyList.decorate(documentReferences, FactoryUtils.instantiateFactory(DocumentReference.class))
    }

    // The taskProcedure holds the procedure id number.
    def getTaskProcedureId() {
        taskProcedure.id
    }

    static mappedBy = [tasks:"taskProcedureRevision"]

    static mapping = {
        taskProcedure lazy:false
        linkedTask lazy:false
        tasks batchSize: 10
        maintenanceActions cascade:"all-delete-orphan"
        documentReferences cascade:"all-delete-orphan"
    }

    static belongsTo = [TaskProcedure]

    static constraints = {
    }

    String toString() {
        "${this.id}"
    }

    def getRevisionDateString() {
        "${this.revision} -- ${dateCreated.format('EEE, dd-MMM-yyyy')}"
    }

    def getFullRevisionString() {
        "${this.revision} -- ${createdBy} on ${dateCreated.format('EEE, dd-MMM-yyyy @ HH:mm')}"
    }
}
