
    <g:if test="${subTaskInstanceTotal > 0}">
        <div class="list">
            <table>
                <thead>
                    <tr>

                        <th>Task #</th>

                        <th>Target Start Date</th>

                        <th>Description</th>

                        <th>
                            <img src="${resource(dir:'images/skin',file:'status.png')}" title="Status" alt="Status" />
                        </th>

                        <th>Priority</th>

                        <th></th>

                    </tr>
                </thead>
                <tbody>
                <g:each in="${subTaskInstanceList}" status="i" var="subTaskInstance">
                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                            ${fieldValue(bean:subTaskInstance, field:'id')}
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                            <g:formatDate date="${subTaskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                            <g:if test="${subTaskInstance.primaryAsset}">
                                ${fieldValue(bean:subTaskInstance, field:'primaryAsset')}:
                            </g:if>
                            ${fieldValue(bean:subTaskInstance, field:'description')}
                        </td>

                        <td class="idColumn" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                            <g:if test="${subTaskInstance.taskStatus.id == 1}" >
                                <img  src="${resource(dir:'images/skin',file:'not_started.png')}" alt="Not Started" title="Not Started" />
                            </g:if>
                            <g:if test="${subTaskInstance.taskStatus.id == 2}" >
                                <img  src="${resource(dir:'images/skin',file:'arrow_right.png')}" alt="In Progress" title="In Progress" />
                            </g:if>
                            <g:if test="${subTaskInstance.taskStatus.id == 3}" >
                                <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Complete" title="Complete" />
                            </g:if>
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                            ${fieldValue(bean:subTaskInstance, field:'taskPriority')}
                        </td>

                        <td class="notClickable">
                            <g:link action="show" id="${subTaskInstance.id}">
                                <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                            </g:link>
                        </td>

                    </tr>
                </g:each>
                </tbody>
            </table>
        </div>

        <div class="buttons">
            <g:form>
                <g:hiddenField name="id" value="${taskInstance?.id}" />
                <g:if test="${subTaskInstanceTotal > subTaskInstanceMax}">
                    Showing ${subTaskInstanceMax} of ${subTaskInstanceTotal}
                    <br />
                </g:if>
                <g:else>
                    Total ${subTaskInstanceTotal}
                    <br />
                </g:else>
                <span class="button"><g:actionSubmit action="listSubTasks" class="table" value="List" /></span>
                <span class="button"><g:actionSubmit action="createSubTask" class="save" value="Create" onclick="return confirm('${g.message(code: 'sub.task.create.confirm')}');" /></span>
            </g:form>
        </div>

    </g:if>
    <g:else>
        <br />
        No Sub Tasks.
        <br />
        <br />

        <div class="buttons">
            <g:form>
                <g:hiddenField name="id" value="${taskInstance?.id}" />
                <span class="button"><g:actionSubmit action="createSubTask" class="save" value="Create" onclick="return confirm('${g.message(code: 'sub.task.create.confirm')}');" /></span>
            </g:form>
        </div>
    </g:else>
