<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show Task #${taskInstance.id}</title>
        <nav:resources override="true"/>
        <resource:tabView skin="tabviewCustom" />
        <resource:dateChooser />
        <g:javascript src="taskShow.js" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:if test="${taskInstance.trash}" >
                <div class="errors">
                        <ul><li>This task is in the trash bin, but can be restored if required.<li><ul>
                </div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>

            <div class="tabHeader">
                <g:render template="showTabHeader" />
            </div>

            <br/>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="${showTab.task}" title="Details" />
                    <g:if test="${taskProcedureExits}">
                        <richui:tabLabel selected="${showTab.procedure}" title="Procedure (!)" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.procedure}" title="Procedure" />
                    </g:else>
                    <g:if test="${taskRecurringScheduleExits}">
                        <richui:tabLabel selected="${showTab.recurrence}" title="Recurrence (!)" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.recurrence}" title="Recurrence" />
                    </g:else>
                    <g:if test="${!inventoryMovementList.isEmpty()}">
                        <richui:tabLabel selected="${showTab.inventory}" title="Inventory (${inventoryMovementList.size()})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.inventory}" title="Inventory (0)" />
                    </g:else>
                    <g:if test="${subTaskInstanceTotal > 0}">
                        <richui:tabLabel selected="${showTab.subTasks}" title="Sub Tasks (${subTaskInstanceTotal})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.subTasks}" title="Sub Tasks (0)" />
                    </g:else>
                </richui:tabLabels>

                <richui:tabContents>

                    <richui:tabContent>
                        <g:render template="showTaskTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showProcedureTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showRecurrenceTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showInventoryTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showSubTaskTab" />
                    </richui:tabContent>

                </richui:tabContents>
            </richui:tabView>

        </div> <!--body-->
    </body>
</html>
