class Person {
    static transients = ['pass']
    static hasMany = [authorities: Authority,
                        personGroups: PersonGroup,
                        taskModifications: TaskModification,
                        entries: Entry,
                        tasks: Task,
                        contacts: Contact,
                        addresses: Address,
                        purchasingGroups: PurchasingGroup]

    static belongsTo = [Authority]

    Department department

    String loginName
    String firstName
    String lastName
    String employeeID = ''

    /* Set after login by 'welcome' action, default to 12 hours, aka "sess.setMaxInactiveInterval(seconds) */
    Integer sessionTimeout = 43200

    /** MD5 Password */
    String password

    /** enabled */
    boolean isActive = true

    /** description */
    String description = ''

    /** plain password to create a MD5 password */
    String pass

    static constraints = {
        loginName(blank: false, unique: true, minSize:4) //minSize:7
        firstName(blank: false)
        lastName(blank: false)
        employeeID()
        description()
        department(nullable:true)
        isActive()
        //Enforcing minSize on password does not work since "" gets encoded to a string.
        password(blank: false)
        //So we need to use pass for validation then encode it for above.
        pass(blank: false, minSize:4) //minSize:7
        sessionTimeout(min:60, max:43200)
    }

    //Overriding the default toString method
    String toString() {"${this.firstName} ${this.lastName}"}

    //  This additional setter is used to convert the checkBoxList string or string array
    //  of ids selected to the corresponding domain objects.
    public void setPersonGroupsFromCheckBoxList(ids) {
        def idList = []
        if(ids instanceof String) {
                if(ids.isInteger())
                    idList << ids.toLong()
        }
        else {
            ids.each() {
                if(it.isInteger())
                    idList << it.toLong()
            }
        }
        this.personGroups = idList.collect { PersonGroup.get( it ) }
    }

    //  This additional setter is used to convert the checkBoxList string or string array
    //  of ids selected to the corresponding domain objects.
    public void setPurchasingGroupsFromCheckBoxList(ids) {
        def idList = []
        if(ids instanceof String) {
                if(ids.isInteger())
                    idList << ids.toLong()
        }
        else {
            ids.each() {
                if(it.isInteger())
                    idList << it.toLong()
            }
        }
        this.purchasingGroups = idList.collect { PurchasingGroup.get( it ) }
    }

} // end class
