/**
 * Provides a service class with methods to interact with AppConfig.
 * AppConfig stores various application configuration (settings) in the database.
 */
class AppConfigService {

    boolean transactional = false

    /**
    * Set the value of an appConfig.
    * @param name The name of the appConfig.
    * @param value Set to this value if specified else defaults to "true".
    * @returns True if success otherwise false.
    */
    public Boolean set(String name, String value = "true") {
        def appConfig = AppConfig.findByName(name)
        appConfig ? (appConfig.value = value) : (appConfig = new AppConfig(name: name, value: value))
        appConfig.save() ? true : false
    }

    /**
    * Check if an appConfig exists.
    * @param name The name of the appConfig.
    * @returns True if success otherwise false.
    */
    public Boolean exists(String name) {
        AppConfig.findByName(name) ? true : false
    }

    /**
    * Get the value of an appConfig.
    * @param name The name of the appConfig.
    * @returns The value of the appConfig else false.
    */
    def getValue(String name) {
        def appConfig = AppConfig.findByName(name)
        appConfig ? appConfig.value : false
    }

    /**
    * Delete an appConfig.
    * @param name The name of the appConfig.
    * @returns True if success otherwise false.
    */
    public Boolean delete(String name) {
        try {
            AppConfig.findByName(name).delete(flush:true)
            return true
        }
        catch(e) {
            log.debug("Could not delete, appConfig may not exist.")
            return false
        }
    }

} // end of class
