/**
 * Domain class that stores various application configuration (settings) in the database.
 * Use AppConfigService to interact with the instances.
 */
class AppConfig {
    String name
    String value
    String description = ''

    static constraints = {
        name(maxSize:100,unique:true,blank:false)
        value(maxSize:500,blank:false)
        description(maxSize:500)
    }

    String toString() {
        "${this.name} = ${this.value}"
    }
}
