class Address {

    AddressType addressType

    Supplier supplier
    Person person
    Site site

    String street1 = ''
    String street2 = ''
    String city = ''
    String state = ''
    String postCode = ''
    String country = ''

//     hasMany = []

    static belongsTo = [Supplier, Person, Site]

    static constraints = {
        street1(blank:false,maxSize:50)
        street2(maxSize:50)
        city(blank:false,maxSize:50)
        state(blank:false,maxSize:50)
        postCode(blank:false,maxSize:50)
        country(blank:false,maxSize:50)
        supplier(nullable:true)
        person(nullable:true)
        site(nullable:true)
    }

    String toString() {
        "${this.addressType}: ${this.street1}, ${this.city}"
    }

}