class Picture {

    InventoryItem inventoryItem
    SortedSet images
    String file
    Integer operation
    String contentType
    Integer width
    Integer height
    Date dateCreated = new Date()
    Date lastUpdated = new Date()

    static belongsTo = [ InventoryItem ]
    static hasMany = [ images : Image ]

    static transients = [ 'file', 'operation']

    static constraints = {
    }

    static mapping = {
        images cascade: 'all-delete-orphan', inverse: true
    }

    static final Integer NoOp = 0
    static final Integer RotateClockWise90 = 1
    static final Integer RotateAntiClockWise90 = 2
    static final Integer Rotate180 = 3
    static final Integer Flip = 4
    static final Integer Flop = 5

}