

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>TaskProcedure List</title>
        <filterpane:includes />
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <filterpane:currentCriteria domainBean="TaskProcedure"
                                    action="list"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
                Results: ${taskProcedureInstanceList.size()} / ${taskProcedureInstanceTotal}
            </div>


            <g:if test="${taskProcedureInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>

                                <g:sortableColumn property="id" title="Id"  params="${filterParams}" />

                                <th>Task Description</th>

                                <th></th>

                            </tr>
                        </thead>
                        <tbody>
                        <g:each in="${taskProcedureInstanceList}" status="i" var="taskProcedureInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskProcedureDetailed/show/${taskProcedureInstance.id}"'/>

                                <td>${fieldValue(bean:taskProcedureInstance, field:'id')}</td>

                                <td>${taskProcedureInstance.tasks.encodeAsHTML()}</td>

                                <td>
                                    <g:link action="show" id="${taskProcedureInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>

            <div class="paginateButtons">
                <g:paginate total="${taskProcedureInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="TaskProcedure"
                                    title="Search"
                                    action="list"
                                    class="overlayPane"
                                    excludeProperties="" />
        </div>
    </body>
</html>
