import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_TaskManager'])
class TaskProcedureDetailedController extends BaseController {

    def filterService

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_TaskManager', 'ROLE_TaskUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)

        if(!params.filter)
        { return [taskProcedureInstanceList: TaskProcedure.list(params), taskProcedureInstanceTotal: TaskProcedure.count()] }

        // filterPane:
        return[ taskProcedureInstanceList: filterService.filter( params, TaskProcedure ),
            taskProcedureInstanceTotal: filterService.count( params, TaskProcedure ),
            filterParams: com.zeddware.grails.plugins.filterpane.FilterUtils.extractFilterParams(params),
            params:params ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_TaskManager', 'ROLE_TaskUser'])
    def search = {
        redirect(action:list)
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_TaskManager', 'ROLE_TaskUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def taskProcedureInstance = TaskProcedure.get( params.id )

        if(!taskProcedureInstance) {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskProcedureInstance : taskProcedureInstance ] }
    }

    def delete = {
        def taskProcedureInstance = TaskProcedure.get( params.id )
        if(taskProcedureInstance) {
            try {
                taskProcedureInstance.tasks.each {
                    it.taskProcedure = null
                }
                taskProcedureInstance.delete(flush:true)
                flash.message = "TaskProcedure ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskProcedure ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def taskProcedureInstance = TaskProcedure.get( params.id )

        if(!taskProcedureInstance) {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskProcedureInstance : taskProcedureInstance ]
        }
    }

    def update = {
        def taskProcedureInstance = TaskProcedure.get( params.id )
        if(taskProcedureInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskProcedureInstance.version > version) {

                    taskProcedureInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[taskProcedureInstance:taskProcedureInstance])
                    return
                }
            }
            taskProcedureInstance.properties = params

            def toBeDeleted = taskProcedureInstance.maintenanceActions.findAll {it.deleted}
            if(toBeDeleted) {
                taskProcedureInstance.maintenanceActions.removeAll(toBeDeleted)
            }

            if(!taskProcedureInstance.hasErrors() && taskProcedureInstance.save(flush: true)) {
                flash.message = "TaskProcedure ${params.id} updated"
                redirect(action:show,id:taskProcedureInstance.id)
            }
            else {
                render(view:'edit',model:[taskProcedureInstance:taskProcedureInstance])
            }
        }
        else {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        if(params.taskInstance?.id) {
            def taskInstance = Task.get(params.taskInstance.id)

            def taskProcedureInstance = new TaskProcedure()
            taskProcedureInstance.properties = params
            return ['taskProcedureInstance':taskProcedureInstance,
                            taskInstance: taskInstance]
        } else {
            flash.message = "Please select or create a task, then go to the Procedure tab."
            redirect(controller:"taskDetailed", action:"search")
        }
    }

    def save = {
        def taskProcedureInstance = new TaskProcedure(params)
        def taskInstance = Task.get(params.linkedTask.id)

        if(!taskProcedureInstance.hasErrors() && taskProcedureInstance.save(flush: true)) {
            taskProcedureInstance.addToTasks(taskInstance) // also sets: taskInstance.taskProcedure = taskProcedureInstance
            flash.message = "TaskProcedure ${taskProcedureInstance.id} created."
            redirect(action:show,id:taskProcedureInstance.id)
        }
        else {
            render(view:'create',model:[taskProcedureInstance:taskProcedureInstance, taskInstance: taskInstance])
        }
    }
}
