<script type="text/javascript">
    var childCount = ${taskProcedureInstance?.maintenanceActions.size()} + 0;
    var ma_wrapperId = "ma_wrapper";
    var ma_cloneId = "maintenanceActionLazyList_clone";
    var ma_lazyList = "maintenanceActionLazyList";
    var ma_fields = ["toBeDeleted", "isNew", "description", "reasoning", "assetSubItem.id", "procedureStepNumber"];
    var ma_focusField = "procedureStepNumber";


    function addChild(wrapperId, cloneId, lazyList, fields, focusField){

        var clone = jQuery("#"+cloneId).clone();
        clone.attr('id', lazyList+childCount);
        var htmlId = lazyList+'['+childCount+'].';

        var fieldsMap = {};
        jQuery.each(fields, function(index, field) {
            fieldsMap[field] = clone.find('[id$="'+field+'"]');
            fieldsMap[field].attr('id',htmlId + field)
                                        .attr('name',htmlId + field);
            if(field == 'isNew') {
                fieldsMap[field].attr('value', 'true');
            }
        });

        jQuery("#"+wrapperId).append(clone);
        clone.show();
        fieldsMap[focusField].focus();
        childCount++;
    }

    // Click event on add button.
    jQuery('.add-ma').live('click', function() {
            addChild(ma_wrapperId, ma_cloneId, ma_lazyList, ma_fields, ma_focusField);
    });

    // Click event on delete buttons.
    jQuery('.del-ma').live('click', function() {
        //find the parent div
        var prnt = jQuery(this).parents(".ma-div");
        //find the deleted hidden input
        var delInput = prnt.find("input[id$=toBeDeleted]");
        //check if this is still not persisted
        var newValue = prnt.find("input[id$=isNew]").attr('value');
        //if it is new then i can safely remove from dom
        if(newValue == 'true'){
            prnt.remove();
        }else{
            //set the deletedFlag to true
            delInput.attr('value','true');
            //hide the div
            prnt.hide();
        }
    });

    jQuery(window).load(function() {
        if(childCount == 0) {
            addChild(ma_wrapperId, ma_cloneId, ma_lazyList, ma_fields, ma_focusField);
        }
    });

</script>



    <div>
        <table>
            <thead>
                <tr>

                    <th>Step</th>
                    <th>Assembly</th>
                    <th>Description</th>
                    <th>Reasoning</th>
                    <th></th>

                </tr>
            </thead>
            <tbody id="ma_wrapper">
                    <g:each var="ma" in="${taskProcedureInstance.maintenanceActions}" status="i">
                            <g:render template="maintenanceAction" model="['tp':taskProcedureInstance,
                                                                                                                'ma': ma,
                                                                                                                'i':i,
                                                                                                                'assemblies': assemblies]" />
                    </g:each>
                    </tr>
            </tbody>
        </table>
    </div>

    <br />

    <div style="text-align:right;">
        <span class="buttons add-ma">
            <input type="button" class="add" value="Add MaintenanceAction" />
        </span>
    </div>
