<html>
    <head>
        <meta name="layout" content="main" />
        <title>Picture List</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <h1>Picture List</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <div class="list">
                <table>
                    <thead>
                        <tr>
                            <th>Picture</th>
                            <g:sortableColumn property="inventoryItem" title="Inventory Item" />
                            <g:sortableColumn property="dateCreated" title="Date Created" />
                            <g:sortableColumn property="lastUpdated" title="Last Updated" />
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <g:each in="${list}" status="i" var="picture">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">
                                <td class="notClickable">
                                    <wa:pictureLightboxAnchor picture="${picture}"
                                                                                        size="${Image.Small}"
                                                                                        lightboxSize="${Image.Large}"
                                                                                        target="_blank" title="Show Original" />
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/pictureDetailed/show/${picture.id}"' >
                                    <g:link controller="inventoryItemDetailed" action="show" id="${picture.inventoryItem?.id}" title="Show Inventory Item">
                                        ${picture.inventoryItem?.toString()?.encodeAsHTML()}
                                    </g:link>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/pictureDetailed/show/${picture.id}"' >
                                    <g:formatDate format="EEE, dd-MMM-yyyy" date="${picture.dateCreated}"/>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/pictureDetailed/show/${picture.id}"' >
                                    <g:formatDate format="EEE, dd-MMM-yyyy" date="${picture.lastUpdated}"/>
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${picture.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>
                            </tr>
                        </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${paginateCount}" />
            </div>
        </div>
    </body>
</html>
