import org.codehaus.groovy.grails.commons.ConfigurationHolder

/**
* Provides a quartz job that rebuilds the searchable index for the inventory search.
* With concurrent=false the next job is blocked until the previous job completes.
* We need a hibernate session otherwise we get a LazyInitializationException, default is true but we specify it to be sure.
* Rebuilding the index is required since searchable components are not updated when they change, that is
* until the parent is updated and reindexed. Cascade update is broken in searchable-0.5.5
*/
class InventoryIndexJob {

    def concurrent = false
    def sessionRequired = true

    static triggers = {
        // Cron fields:
        // 'Seconds Minutes Hours DOM Month DOW Year(Optional)'
        // See: http://www.quartz-scheduler.org/docs/tutorials/crontrigger.html
        // Trigger every hour on the hour:
        //cron name: 'RebuildInventoryIndex', cronExpression: "0 0 * * * ?"
    }

    def execute(context) {

        // Some information can be accessed if we run with "def execute(context) ".
        // For more info see: http://quartz.sourceforge.net/javadoc/org/quartz/JobExecutionContext.html
        // log.debug context.getTrigger()
        // log.debug context.getPreviousFireTime()
        // log.debug context.getFireTime()

        // Called by.
        def calledBy =  context.mergedJobDataMap.get('calledBy')
        log.info "Called By: " + calledBy

        // Rebuild the Inventory searchable index.
        log.info "Calling, Inventory.index()."
        InventoryItem.index()
    }
}
