class DocumentReference {

    String name
    String location

    Boolean toBeDeleted
    Boolean isNew
    static transients = [ 'toBeDeleted', 'isNew' ]

//     static hasMany = []

    static belongsTo = [TaskProcedure, TaskProcedureRevision]

    static mapping = {
        batchSize 10
    }

    static constraints = {
        name(blank:false,maxSize:75)
        location(blank:false,maxSize:500)
    }

    String toString() {
        "${this.name} - ${this.location}"
    }
}

