import org.codehaus.groovy.grails.commons.ConfigurationHolder

class InventoryGroup {
    String name
    String description = ""
    boolean isActive = true

    static hasMany = [inventoryItems : InventoryItem]

    static constraints = {
        name(maxSize:50,unique:true,blank:false)
        description(maxSize:100)
    }

    String toString() {"${this.name}"}

    static searchable = {
        root false // only index as a component of InventoryItem.
        only = ['name']
    }

    def afterUpdate = {
        // Update the Inventory searchable index, since cascading in searchable-0.5.5 is broken.
        if(ConfigurationHolder.config.appSearchable.cascadeOnUpdate) {
            try {
                InventoryIndexJob.triggerNow(['calledBy':'InventoryGroup afterUpdate{}'])
            }
            catch(e) {log.error e}
        } // if
    } // afterUpdate

}
