import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskStatusController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ taskStatusInstanceList: TaskStatus.list( params ) ]
    }

    def show = {
        def taskStatusInstance = TaskStatus.get( params.id )

        if(!taskStatusInstance) {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskStatusInstance : taskStatusInstance ] }
    }

    def delete = {
        def taskStatusInstance = TaskStatus.get( params.id )
        if(taskStatusInstance) {
            taskStatusInstance.delete()
            flash.message = "TaskStatus ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskStatusInstance = TaskStatus.get( params.id )

        if(!taskStatusInstance) {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskStatusInstance : taskStatusInstance ]
        }
    }

    def update = {
        def taskStatusInstance = TaskStatus.get( params.id )
        if(taskStatusInstance) {
            taskStatusInstance.properties = params
            if(!taskStatusInstance.hasErrors() && taskStatusInstance.save()) {
                flash.message = "TaskStatus ${params.id} updated"
                redirect(action:show,id:taskStatusInstance.id)
            }
            else {
                render(view:'edit',model:[taskStatusInstance:taskStatusInstance])
            }
        }
        else {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def taskStatusInstance = new TaskStatus()
        taskStatusInstance.properties = params
        return ['taskStatusInstance':taskStatusInstance]
    }

    def save = {
        def taskStatusInstance = new TaskStatus(params)
        if(!taskStatusInstance.hasErrors() && taskStatusInstance.save()) {
            flash.message = "TaskStatus ${taskStatusInstance.id} created"
            redirect(action:show,id:taskStatusInstance.id)
        }
        else {
            render(view:'create',model:[taskStatusInstance:taskStatusInstance])
        }
    }
}
