

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Period</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Period List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Period</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Period</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${periodInstance}">
            <div class="errors">
                <g:renderErrors bean="${periodInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${periodInstance?.id}" />
                <input type="hidden" name="version" value="${periodInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:periodInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${periodInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="period">Period:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:periodInstance,field:'period','errors')}">
                                    <input type="text" id="period" name="period" value="${fieldValue(bean:periodInstance,field:'period')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recurringSchedules">Recurring Schedules:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:periodInstance,field:'recurringSchedules','errors')}">
                                    
<ul>
<g:each var="r" in="${periodInstance?.recurringSchedules?}">
    <li><g:link controller="recurringSchedule" action="show" id="${r.id}">${r?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="recurringSchedule" params="['period.id':periodInstance?.id]" action="create">Add RecurringSchedule</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
