import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AppCoreController extends BaseController {

    def authenticateService

    def index = { redirect(action:home,params:params) }

    // the delete, save and update actions only accept POST requests
    //def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def welcome = {
        def personInstance = Person.get(authenticateService.userDomain().id)
        flash.message = "Welcome, ${personInstance.firstName} ${personInstance.lastName}."

        def sess = getSession()
        sess.setMaxInactiveInterval(personInstance.sessionTimeout)
        redirect(action:home)
    }

    def home = {
    }

    def options = {
    }

    def acknowledgements = {
    }

    def changeSessionTimeout = {
        if (request.method == 'GET') {
            def personInstance = Person.get(authenticateService.userDomain().id)
            return [ personInstance : personInstance ]       
        }
        if (request.method == 'POST') {
            def personInstance = Person.get(authenticateService.userDomain().id)
//             personInstance.sessionTimeout = params.sessionTimeout.toInteger()
                personInstance.properties = params
                if (!personInstance.hasErrors() && personInstance.save()) {
                    def sess = getSession()
                    sess.setMaxInactiveInterval(personInstance.sessionTimeout)
                    flash.message = "Session timeout changed."
                    redirect(action:options)
                }
                else {
                    render(view:'changeSessionTimeout',model:[personInstance:personInstance])
                }
        }
    }         

    def changePassword = {
        //def principal = authenticateService.principal()
        //println principal.getAuthorities()

        if (request.method == 'GET') {
            def personInstance = Person.get(authenticateService.userDomain().id)
            return [ personInstance : personInstance ]       
        }  

        if (request.method == 'POST') {
            def personInstance = Person.get(authenticateService.userDomain().id)

            if(params.confirmPass == params.pass) {
                personInstance.pass = params.pass
                personInstance.password = authenticateService.encodePassword(personInstance.pass)

                if (!personInstance.hasErrors() && personInstance.save()) {
                    //userCache.removeUserFromCache(personInstance.loginName)
                    flash.message = "Password changed successfully."
                    redirect(action:options)
                }
                else {
                    render(view:'changePassword',model:[personInstance:personInstance])
                }
            }
            else {
                personInstance.errors.reject('person.pass.doesNotMatch',            // Error code, see grails-app/i18n/message.properties
                                                                ['pass', 'class Person'].toArray(),      // Groovy ListArray cast to Object[]
                                                                 '[NothingUseMessageProperites]')  // Default mapping string.
                render(view:'changePassword',model:[personInstance:personInstance])
            }
                
        }  
    }

    @Secured(['ROLE_Manager'])   
    def manager = {
    }

    @Secured(['ROLE_AppAdmin'])   
    def appAdmin = {
    }

}