<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <filterpane:includes />
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        
        <div class="body">
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>
            <g:if test="${params.message}">
                <div class="message">${params.message}</div>
            </g:if>
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>
            <filterpane:currentCriteria domainBean="Task"
                                    action="search"
                                    dateFormat="${'EEE, dd-MMM-yyyy'}"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Quick Search"/>
            
            <div class="list">                
                <table>
                    <thead>
                        <tr>
                        
                   	        <g:sortableColumn property="id" title="Id" params="${filterParams}" />
                        
                   	        <g:sortableColumn property="targetStartDate" title="Target Start Date" params="${filterParams}" />
                        
                   	        <g:sortableColumn property="description" title="Description" params="${filterParams}" />
                        
                   	        <g:sortableColumn  property="leadPerson" title="Lead Person" params="${filterParams}" />
                        
                            <g:sortableColumn  property="taskPriority" title="Task Priority" params="${filterParams}" />
                        
                            <g:sortableColumn  property="taskStatus" title="Task Status" params="${filterParams}" />

                            <th></th>
                   	    
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'/>

                            <td>${fieldValue(bean:taskInstance, field:'id')}</td>
                        
                            <td><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'description')}</td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'leadPerson')}</td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'taskPriority')}</td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'taskStatus')}</td>

                            <td>
                                <g:link action="show" id="${taskInstance.id}">
                                    <img  src="${createLinkTo(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>
                        
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${taskInstanceTotal}" params="${filterParams}" />
                <filterpane:filterButton text="Search" appliedText="Change Search" />
                Results:${taskInstanceTotal}
                <g:link action="advancedSearch">Goto: Advanced Search</g:link>
            </div>
            
            <filterpane:filterPane domainBean="Task"
                                    title="Quick Search"
                                    action="search"
                                    additionalProperties="id"
                                    excludeProperties="isActive, comment, targetCompletionDate"
                                    associatedProperties="leadPerson.lastName, taskPriority.name"
                                    filterPropertyValues="${['taskPriority.name':[values:TaskPriority.list()],
                                                                                'leadPerson.lastName':[values:Person.executeQuery('select t.lastName from Person t')],
                                                                                targetStartDate:[years:2020..2000,precision:'day']]}"/>
        </div> <!-- end body div -->
    </body>
</html>
