dataSource {
    pooled = true
}
hibernate {
    cache.use_second_level_cache=true
    cache.use_query_cache=true
    cache.provider_class='com.opensymphony.oscache.hibernate.OSCacheProvider'
}

// Environment specific settings.
// create-drop: Drop and re-create the database between sessions. Deletes existing data.
// create:       Create the database if it doesn't exist, but don't modify it if it does. Deletes existing data.
// update:     Create the database if it doesn't exist, and modify it if it does exist. Keep data.
environments {
    development {
        dataSource {
            /** HSQLDB - In memory */
            driverClassName = "org.hsqldb.jdbcDriver"
            username = "sa"
            password = ""
            dbCreate = "create-drop"
            url = "jdbc:hsqldb:mem:devDB"
            /** MySQL */
//             driverClassName = "com.mysql.jdbc.Driver"
//             username = "gnumimsadmin"
//             password = "gnumimsadmin"
//             dbCreate = "create-drop"
//             url = "jdbc:mysql://host:3306/gnumims_dev"
        }
    }
    test {
        dataSource {
            /** HSQLDB - In memory */
            driverClassName = "org.hsqldb.jdbcDriver"
            username = "sa"
            password = ""
            dbCreate = "update"
            url = "jdbc:hsqldb:mem:devDb"
            /** MySQL */
//             driverClassName = "com.mysql.jdbc.Driver"
//             username = "gnumimsadmin"
//             password = "gnumimsadmin"
//             dbCreate = "update"
//             url = "jdbc:mysql://host:3306/gnumims_test"
        }
    }
    production {
        dataSource {
            /* Delete dbCreate line after setup! */
            /** HSQLDB - In memory */
//             driverClassName = "org.hsqldb.jdbcDriver"
//             username = "sa"
//             password = ""
//             dbCreate = "create-drop"
//             url = "jdbc:hsqldb:mem:devDB"
            /** HSQLDB - In file */
//             driverClassName = "org.hsqldb.jdbcDriver"
//             username = "sa"
//             password = ""
//             dbCreate = "update"
//             url = "jdbc:hsqldb:file:prodDb;shutdown=true"
            /** MySQL */
            driverClassName = "com.mysql.jdbc.Driver"
            username = "gnumimsadmin"
            password = "gnumimsadmin"
            dbCreate = "update"
            url = "jdbc:mysql://gnumimssql01:3306/gnumims_prod"
        }
    }
}