

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Period</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${resource(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Period List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Period</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Period</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${periodInstance}">
            <div class="errors">
                <g:renderErrors bean="${periodInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${periodInstance?.id}" />
                <input type="hidden" name="version" value="${periodInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:periodInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${periodInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="period">Period:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:periodInstance,field:'period','errors')}">
                                    <input type="text" id="period" name="period" value="${fieldValue(bean:periodInstance,field:'period')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskRecurringSchedules">Task Recurring Schedules:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:periodInstance,field:'taskRecurringSchedules','errors')}">
                                    
<ul>
<g:each var="t" in="${periodInstance?.taskRecurringSchedules?}">
    <li><g:link controller="taskRecurringSchedule" action="show" id="${t.id}">${t?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="taskRecurringSchedule" params="['period.id':periodInstance?.id]" action="create">Add TaskRecurringSchedule</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
