

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Supplier</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${resource(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Supplier List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Supplier</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Supplier</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${supplierInstance}">
            <div class="errors">
                <g:renderErrors bean="${supplierInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${supplierInstance?.id}" />
                <input type="hidden" name="version" value="${supplierInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:supplierInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItems">Inventory Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'inventoryItems','errors')}">
                                    
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${supplierInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:supplierInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="supplierType">Supplier Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'supplierType','errors')}">
                                    <g:select optionKey="id" from="${SupplierType.list()}" name="supplierType.id" value="${supplierInstance?.supplierType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
