import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class PersonGroupController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ personGroupInstanceList: PersonGroup.list( params ), personGroupInstanceTotal: PersonGroup.count() ]
    }

    def show = {
        def personGroupInstance = PersonGroup.get( params.id )

        if(!personGroupInstance) {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ personGroupInstance : personGroupInstance ] }
    }

    def delete = {
        def personGroupInstance = PersonGroup.get( params.id )
        if(personGroupInstance) {
            try {
                personGroupInstance.delete(flush:true)
                flash.message = "PersonGroup ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "PersonGroup ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def personGroupInstance = PersonGroup.get( params.id )

        if(!personGroupInstance) {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ personGroupInstance : personGroupInstance ]
        }
    }

    def update = {
        def personGroupInstance = PersonGroup.get( params.id )
        if(personGroupInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(personGroupInstance.version > version) {
                    
                    personGroupInstance.errors.rejectValue("version", "personGroup.optimistic.locking.failure", "Another user has updated this PersonGroup while you were editing.")
                    render(view:'edit',model:[personGroupInstance:personGroupInstance])
                    return
                }
            }
            personGroupInstance.properties = params
            if(!personGroupInstance.hasErrors() && personGroupInstance.save()) {
                flash.message = "PersonGroup ${params.id} updated"
                redirect(action:show,id:personGroupInstance.id)
            }
            else {
                render(view:'edit',model:[personGroupInstance:personGroupInstance])
            }
        }
        else {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def personGroupInstance = new PersonGroup()
        personGroupInstance.properties = params
        return ['personGroupInstance':personGroupInstance]
    }

    def save = {
        def personGroupInstance = new PersonGroup(params)
        if(!personGroupInstance.hasErrors() && personGroupInstance.save()) {
            flash.message = "PersonGroup ${personGroupInstance.id} created"
            redirect(action:show,id:personGroupInstance.id)
        }
        else {
            render(view:'create',model:[personGroupInstance:personGroupInstance])
        }
    }
}
