class Person {
    PersonGroup personGroup
    String firstName
    String lastName
    Integer employeeID
    boolean isActive = true

    static hasMany = [modifications : Modification,
                        entries : Entry, tasks : Task,
                        personGroups : PersonGroup]

    static belongsTo = [PersonGroup]

    static optionals = ["employeeID"]

    static constraints = {
        firstName()
        lastName()
        employeeID()
    }

    //Overriding the default toString method
    String toString() {"${this.firstName}:"{this.lastName}}
}
