import java.text.SimpleDateFormat

class InventoryMovement {
    InventoryItem inventoryItem
    InventoryMovementType inventoryMovementType
    Task task
    Integer quantity
    Date date = new Date()

//     static belongsTo = []

    static constraints = {
        inventoryItem()
        quantity(min:1)
        inventoryMovementType()
        task(nullable:true)
        date()
    }

    String toString() {
        def date = new SimpleDateFormat("EEE, dd-MMM-yyyy").format(this.date)
        "${this.quantity} ${inventoryMovementType.name} on ${date}"
    }
}