class TaskSearchService {

    boolean transactional = false

    def dateUtilService
    def authenticateService

    def getTodays(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, 100)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "id"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                ge("targetStartDate", dateUtilService.getToday())
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getMyTodays(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, 100)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "id"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                eq("leadPerson", Person.get(authenticateService.userDomain().id))
                ge("targetStartDate", dateUtilService.getToday())
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getInTheLastWeek(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, 100)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "id"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                ge("targetStartDate", dateUtilService.getToday()-7)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getMyInTheLastWeek(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, 100)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "id"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                eq("leadPerson", Person.get(authenticateService.userDomain().id))
                ge("targetStartDate", dateUtilService.getToday()-7)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getBudgetPlanned(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, 100)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "id"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort,
            order: params.order) {
                ne("taskType", TaskType.findByName("Unscheduled Breakin"))
                ge("targetStartDate", dateUtilService.getToday()-7)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getBudgetUnplanned(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, 100)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "id"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort,
            order: params.order) {
                eq("taskType", TaskType.findByName("Unscheduled Breakin"))
                ge("targetStartDate", dateUtilService.getToday()-7)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }
}
