

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit SystemSection</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="list">SystemSection List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New SystemSection</g:link></span>
        </div>
        <div class="body">
            <h1>Edit SystemSection</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${systemSectionInstance}">
            <div class="errors">
                <g:renderErrors bean="${systemSectionInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${systemSectionInstance?.id}" />
                <input type="hidden" name="version" value="${systemSectionInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:systemSectionInstance,field:'name')}"/>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:systemSectionInstance,field:'description')}"/>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="costCode">Cost Code:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'costCode','errors')}">
                                    <input type="text" id="costCode" name="costCode" value="${fieldValue(bean:systemSectionInstance,field:'costCode')}"/>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="department">Department:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'department','errors')}">
                                    <g:select optionKey="id" from="${Department.list()}" name="department.id" value="${systemSectionInstance?.department?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="site">Site:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'site','errors')}">
                                    <g:select optionKey="id" from="${Site.list()}" name="site.id" value="${systemSectionInstance?.site?.id}" ></g:select>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${systemSectionInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assets">Assets:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'assets','errors')}">
                                    
<ul>
<g:each var="a" in="${systemSectionInstance?.assets?}">
    <li><g:link controller="assetDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="assetDetailed" params="['systemSection.id':systemSectionInstance?.id]" action="create">Add Asset</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:systemSectionInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${systemSectionInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceActionDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceActionDetailed" params="['systemSection.id':systemSectionInstance?.id]" action="create">Add MaintenanceAction</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
