import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskTypeInstanceList: TaskType.list( params ), taskTypeInstanceTotal: TaskType.count() ]
    }

    def show = {
        def taskTypeInstance = TaskType.get( params.id )

        if(!taskTypeInstance) {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskTypeInstance : taskTypeInstance ] }
    }

    def delete = {
        def taskTypeInstance = TaskType.get( params.id )
        if(taskTypeInstance) {
            try {
                taskTypeInstance.delete(flush:true)
                flash.message = "TaskType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskTypeInstance = TaskType.get( params.id )

        if(!taskTypeInstance) {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskTypeInstance : taskTypeInstance ]
        }
    }

    def update = {
        def taskTypeInstance = TaskType.get( params.id )
        if(taskTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskTypeInstance.version > version) {
                    
                    taskTypeInstance.errors.rejectValue("version", "taskType.optimistic.locking.failure", "Another user has updated this TaskType while you were editing.")
                    render(view:'edit',model:[taskTypeInstance:taskTypeInstance])
                    return
                }
            }
            taskTypeInstance.properties = params
            if(!taskTypeInstance.hasErrors() && taskTypeInstance.save(flush: true)) {
                flash.message = "TaskType ${params.id} updated"
                redirect(action:show,id:taskTypeInstance.id)
            }
            else {
                render(view:'edit',model:[taskTypeInstance:taskTypeInstance])
            }
        }
        else {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def taskTypeInstance = new TaskType()
        taskTypeInstance.properties = params
        return ['taskTypeInstance':taskTypeInstance]
    }

    def save = {
        def taskTypeInstance = new TaskType(params)
        if(!taskTypeInstance.hasErrors() && taskTypeInstance.save(flush: true)) {
            flash.message = "TaskType ${taskTypeInstance.id} created"
            redirect(action:show,id:taskTypeInstance.id)
        }
        else {
            render(view:'create',model:[taskTypeInstance:taskTypeInstance])
        }
    }
}
