import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class InventoryGroupController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ inventoryGroupInstanceList: InventoryGroup.list( params ), inventoryGroupInstanceTotal: InventoryGroup.count() ]
    }

    def show = {
        def inventoryGroupInstance = InventoryGroup.get( params.id )

        if(!inventoryGroupInstance) {
            flash.message = "InventoryGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryGroupInstance : inventoryGroupInstance ] }
    }

    def delete = {
        def inventoryGroupInstance = InventoryGroup.get( params.id )
        if(inventoryGroupInstance) {
            try {
                inventoryGroupInstance.delete(flush:true)
                flash.message = "InventoryGroup ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryGroup ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def inventoryGroupInstance = InventoryGroup.get( params.id )

        if(!inventoryGroupInstance) {
            flash.message = "InventoryGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryGroupInstance : inventoryGroupInstance ]
        }
    }

    def update = {
        def inventoryGroupInstance = InventoryGroup.get( params.id )
        if(inventoryGroupInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryGroupInstance.version > version) {
                    
                    inventoryGroupInstance.errors.rejectValue("version", "inventoryGroup.optimistic.locking.failure", "Another user has updated this InventoryGroup while you were editing.")
                    render(view:'edit',model:[inventoryGroupInstance:inventoryGroupInstance])
                    return
                }
            }
            inventoryGroupInstance.properties = params
            if(!inventoryGroupInstance.hasErrors() && inventoryGroupInstance.save(flush: true)) {
                flash.message = "InventoryGroup ${params.id} updated"
                redirect(action:show,id:inventoryGroupInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryGroupInstance:inventoryGroupInstance])
            }
        }
        else {
            flash.message = "InventoryGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def inventoryGroupInstance = new InventoryGroup()
        inventoryGroupInstance.properties = params
        return ['inventoryGroupInstance':inventoryGroupInstance]
    }

    def save = {
        def inventoryGroupInstance = new InventoryGroup(params)
        if(!inventoryGroupInstance.hasErrors() && inventoryGroupInstance.save(flush: true)) {
            flash.message = "InventoryGroup ${inventoryGroupInstance.id} created"
            redirect(action:show,id:inventoryGroupInstance.id)
        }
        else {
            render(view:'create',model:[inventoryGroupInstance:inventoryGroupInstance])
        }
    }
}
