class AssignedGroupService {
    boolean transactional = false

    def list(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup"] ]
            return result
        }

        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        result.assignedGroupInstanceList = AssignedGroup.list(params)
        result.assignedGroupInstanceTotal = AssignedGroup.count()

        if(!result.assignedGroupInstanceList || !result.assignedGroupInstanceTotal)
            return fail(code:"default.list.failure")

        // Success.
        return result
    }

    def show(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        result.assignedGroupInstance = AssignedGroup.get(params.id)

        if(!result.assignedGroupInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def delete(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        result.assignedGroupInstance = AssignedGroup.get(params.id)

        if(!result.assignedGroupInstance)
            return fail(code:"default.not.found")

        try {
            result.assignedGroupInstance.delete(flush:true)
            return result //Success.
        }
        catch(org.springframework.dao.DataIntegrityViolationException e) {
            return fail(code:"default.delete.failure")
        }

    }

    def edit(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        result.assignedGroupInstance = AssignedGroup.get(params.id)

        if(!result.assignedGroupInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def update(params) {
        AssignedGroup.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedGroupInstance && m.field)
                    result.assignedGroupInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
                return result
            }

            result.assignedGroupInstance = AssignedGroup.get(params.id)

            if(!result.assignedGroupInstance)
                return fail(code:"default.not.found")

            // Optimistic locking check.
            if(params.version) {
                if(result.assignedGroupInstance.version > params.version.toLong())
                    return fail(field:"version", code:"default.optimistic.locking.failure")
            }

            result.assignedGroupInstance.properties = params

            if(result.assignedGroupInstance.hasErrors() || !result.assignedGroupInstance.save())
                return fail(code:"default.update.failure")

            // Success.
            return result

        } //end withTransaction
    }  // end update()

    def create(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        if(!params.task?.id)
            fail(code:"assignedGroup.task.not.found")

        result.assignedGroupInstance = new AssignedGroup()
        result.assignedGroupInstance.properties = params

        // success
        return result
    }

    def save(params) {
        def result = [:]
        def fail = { Map m ->
            if(result.assignedGroupInstance && m.field)
                result.assignedGroupInstance.errors.rejectValue(m.field, m.code)
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        result.assignedGroupInstance = new AssignedGroup(params)

        if(result.assignedGroupInstance.hasErrors() || !result.assignedGroupInstance.save(flush: true))
            return fail(code:"default.create.failure")

        // success
        return result
    }

} // end class